/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.sink;

import javax.annotation.Nonnull;

class SlowRecoveryDegrader<T> {
    private final int k;
    private final T[] outputs;
    private final int n;
    private int state;

    SlowRecoveryDegrader(int k, T[] outputs) {
        if (k < 1) {
            throw new IllegalArgumentException("Speed ratio can't be smaller than 1");
        }
        this.k = k;
        if (outputs == null || outputs.length < 2) {
            throw new IllegalArgumentException("At least two outputs needed");
        }
        for (T output : outputs) {
            if (output != null) continue;
            throw new IllegalArgumentException("Output can't be null");
        }
        this.outputs = outputs;
        this.n = outputs.length - 1;
    }

    void ok() {
        if (this.state > 0) {
            --this.state;
        }
    }

    void error() {
        this.state = this.state <= this.k * (this.n - 1) ? (this.state += this.k) : this.k * this.n;
    }

    @Nonnull
    T output() {
        return this.outputs[this.state % this.k == 0 ? this.state / this.k : 1 + this.state / this.k];
    }
}

