/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.amazonaws.services.kinesis.model.transform;

import com.hazelcast.com.amazonaws.SdkClientException;
import com.hazelcast.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.com.amazonaws.services.kinesis.model.ConsumerDescription;
import java.util.Date;

@SdkInternalApi
public class ConsumerDescriptionMarshaller {
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").build();
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").build();
    private static final MarshallingInfo<String> CONSUMERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerStatus").build();
    private static final MarshallingInfo<Date> CONSUMERCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerCreationTimestamp").timestampFormat("unixTimestampInMillis").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final ConsumerDescriptionMarshaller instance = new ConsumerDescriptionMarshaller();

    public static ConsumerDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConsumerDescription consumerDescription, ProtocolMarshaller protocolMarshaller) {
        if (consumerDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(consumerDescription.getConsumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall(consumerDescription.getConsumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall(consumerDescription.getConsumerStatus(), CONSUMERSTATUS_BINDING);
            protocolMarshaller.marshall(consumerDescription.getConsumerCreationTimestamp(), CONSUMERCREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(consumerDescription.getStreamARN(), STREAMARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

