/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.amazonaws.services.kinesis.model;

import com.hazelcast.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.com.amazonaws.services.kinesis.model.ShardFilterType;
import com.hazelcast.com.amazonaws.services.kinesis.model.transform.ShardFilterMarshaller;
import java.io.Serializable;
import java.util.Date;

public class ShardFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String shardId;
    private Date timestamp;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ShardFilter withType(String type) {
        this.setType(type);
        return this;
    }

    public ShardFilter withType(ShardFilterType type) {
        this.type = type.toString();
        return this;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public ShardFilter withShardId(String shardId) {
        this.setShardId(shardId);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public ShardFilter withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getShardId() != null) {
            sb.append("ShardId: ").append(this.getShardId()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardFilter)) {
            return false;
        }
        ShardFilter other = (ShardFilter)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getShardId() == null ^ this.getShardId() == null) {
            return false;
        }
        if (other.getShardId() != null && !other.getShardId().equals(this.getShardId())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        return other.getTimestamp() == null || other.getTimestamp().equals(this.getTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getShardId() == null ? 0 : this.getShardId().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        return hashCode;
    }

    public ShardFilter clone() {
        try {
            return (ShardFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

