/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.util.ResourceUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class KeystoreUtil {
    public static final String DEFAULT_KEYSTORE_TYPE = "JCEKS";
    private static final String KEY_ALIAS = "MC_LDAP_PASS";

    private KeystoreUtil() {
    }

    public static void create(String path, String keyStorePass) {
        KeyStore ks;
        char[] keyStorePassword = keyStorePass.toCharArray();
        try {
            ks = KeyStore.getInstance("JCEKS");
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigApiException("No security provider supports JCEKS keyStore type.", (Throwable)e);
        }
        try {
            ks.load(null, keyStorePassword);
        }
        catch (IOException e) {
            throw KeystoreUtil.wrapIOException((IOException)e);
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("Unexpected exception while loading keyStore from [" + path + "]", (Throwable)e);
        }
        try (FileOutputStream fos = new FileOutputStream(ResourceUtils.getFile((String)path));){
            ks.store(fos, keyStorePassword);
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("Failed to save keyStore data to file [" + path + "]", (Throwable)e);
        }
    }

    public static void store(String path, String keyStorePass, String password) {
        KeystoreUtil.store((String)path, (String)keyStorePass, (String)password, (String)"JCEKS", null);
    }

    public static void store(String path, String keyStorePass, String password, String keyStoreType, String provider) {
        char[] keyStorePassword = keyStorePass.toCharArray();
        KeyStore ks = KeystoreUtil.getKeyStoreInstance((String)keyStoreType, (String)provider);
        try (FileInputStream fis = new FileInputStream(ResourceUtils.getFile((String)path));){
            ks.load(fis, keyStorePassword);
        }
        catch (IOException e) {
            throw KeystoreUtil.wrapIOException((IOException)e);
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("Unexpected exception while loading keyStore from [" + path + "]", (Throwable)e);
        }
        SecretKeySpec secretKey = new SecretKeySpec(password.getBytes(StandardCharsets.UTF_8), "");
        KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(secretKey);
        try {
            ks.setEntry("MC_LDAP_PASS", secretKeyEntry, new KeyStore.PasswordProtection(keyStorePassword));
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigApiException("Failed to store password in keyStore.", (Throwable)e);
        }
        try (FileOutputStream fos = new FileOutputStream(ResourceUtils.getFile((String)path));){
            ks.store(fos, keyStorePassword);
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("Unexpected exception while storing keyStore on [" + path + "]", (Throwable)e);
        }
    }

    public static String load(String path, String keyStorePass) {
        return KeystoreUtil.load((String)path, (String)keyStorePass, (String)"JCEKS", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String load(String path, String keyStorePass, String keyStoreType, String provider) {
        char[] keyStorePassword = keyStorePass.toCharArray();
        KeyStore ks = KeystoreUtil.getKeyStoreInstance((String)keyStoreType, (String)provider);
        try (FileInputStream fis = new FileInputStream(ResourceUtils.getFile((String)path));){
            ks.load(fis, keyStorePassword);
            KeyStore.SecretKeyEntry loadedKey = (KeyStore.SecretKeyEntry)ks.getEntry("MC_LDAP_PASS", new KeyStore.PasswordProtection(keyStorePassword));
            if (loadedKey == null) {
                String string = null;
                return string;
            }
            String string = new String(loadedKey.getSecretKey().getEncoded(), StandardCharsets.UTF_8);
            return string;
        }
        catch (UnrecoverableKeyException e) {
            throw new SecurityConfigApiException("Wrong keyStore password", (Throwable)e);
        }
        catch (IOException e) {
            throw KeystoreUtil.wrapIOException((IOException)e);
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("Unexpected exception while loading keyStore from [" + path + "]", (Throwable)e);
        }
    }

    private static KeyStore getKeyStoreInstance(String keyStoreType, String provider) {
        KeyStore ks;
        try {
            ks = StringUtil.isNullOrEmptyAfterTrim((String)provider) ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, provider);
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigApiException("No security provider supports JCEKS keyStore type.", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityConfigApiException("No such security provider: " + provider, (Throwable)e);
        }
        return ks;
    }

    private static SecurityConfigApiException wrapIOException(IOException e) {
        return new SecurityConfigApiException("Unexpected IO exception while loading keyStore: " + e.getMessage(), (Throwable)e);
    }
}

