/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CryptoUtils {
    private static final int ITERATION_COUNT = 1000;
    private static final SecureRandom RANDOM = new SecureRandom();

    private CryptoUtils() {
    }

    public static String generateRandomToken() {
        byte[] bytes = new byte[32];
        RANDOM.nextBytes(bytes);
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        return encoder.encodeToString(bytes);
    }

    public static String generateHash(String value) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(value.getBytes(StandardCharsets.UTF_8));
            return CryptoUtils.toHex((byte[])hash);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String generatePasswordHash(String username, String password) {
        try {
            char[] chars = password.toCharArray();
            byte[] salt = username.getBytes(StandardCharsets.UTF_8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(chars, salt, 1000, 512);
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return CryptoUtils.toHex((byte[])hash);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }
}

