/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.webmonitor.config.properties.SqlConfigurationProperties;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.sql.SqlRowSetProcessor;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;
import org.springframework.web.socket.messaging.SessionUnsubscribeEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SqlRowSetProcessor
implements InitializingBean,
DisposableBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlRowSetProcessor.class);
    private static final int MAX_ROW_SET_PROCESSOR_THREAD_COUNT = 4;
    static final long PENDING_TASK_EXPIRATION_TIME = TimeUnit.MINUTES.toNanos(5L);
    static final String USER_TOPIC_SQL_RESULTS = "/user/topic/sql-results/";
    private static final int MAX_DESERIALIZATION_EXCEPTION_LOG_RATE = 10;
    private static final Logger DESERIALIZATION_EXCEPTION_LOGGER = RateLimitedLog.withRateLimit((Logger)log).maxRate(10).every(Duration.of(1L, ChronoUnit.MINUTES)).build();
    private final Clock clock;
    private final SimpMessagingTemplate messagingTemplate;
    private final SqlConfigurationProperties sqlConfigurationProperties;
    private final ScheduledExecutorService iterationPool = Executors.newScheduledThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), 4), new ThreadFactoryBuilder().setNameFormat("SQLRowSetProcessor-%d").build());
    private final ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("PendingSqlIterationTasksCleaner").build());
    private final ConcurrentMap<String, PendingTask> pendingTasks = new ConcurrentHashMap();
    private final ConcurrentMap<String, ActiveTask> activeTasks = new ConcurrentHashMap();
    private final ConcurrentMap<String, Set<String>> sessionQueries = new ConcurrentHashMap();

    public void afterPropertiesSet() throws Exception {
        this.cleaner.scheduleAtFixedRate(() -> this.removeExpiredPendingTasks(), 1L, 1L, TimeUnit.MINUTES);
    }

    void removeExpiredPendingTasks() {
        this.pendingTasks.forEach((key, value) -> this.pendingTasks.computeIfPresent(key, (k, v) -> {
            if (v.isExpired()) {
                IteratingSqlRunnable.access$800((IteratingSqlRunnable)PendingTask.access$700((PendingTask)v)).close();
                return null;
            }
            return v;
        }));
    }

    public void destroy() throws Exception {
        this.iterationPool.shutdown();
        this.iterationPool.awaitTermination(1L, TimeUnit.SECONDS);
        this.cleaner.shutdown();
        this.cleaner.awaitTermination(1L, TimeUnit.SECONDS);
    }

    public void addPendingTask(String queryId, String username, SqlClientResult sqlResult) {
        int size = sqlResult.getRowMetadata().getColumns().size();
        IteratingSqlRunnable runnable = new IteratingSqlRunnable(this, username, queryId, sqlResult, size);
        this.pendingTasks.putIfAbsent(queryId, new PendingTask(this, runnable));
    }

    @EventListener
    public void onSessionSubscribe(SessionSubscribeEvent event) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String destination = accessor.getDestination();
        if (destination != null && destination.startsWith("/user/topic/sql-results/")) {
            String queryId = destination.substring(destination.lastIndexOf(47) + 1);
            String subscriptionId = accessor.getSubscriptionId();
            String sessionId = accessor.getSessionId();
            log.debug("Subscribed: queryId = {} subscriptionId = {} sessionId = {}", new Object[]{queryId, subscriptionId, sessionId});
            this.pendingTasks.computeIfPresent(queryId, (k, pendingTask) -> {
                this.sessionQueries.computeIfAbsent(sessionId, id -> Collections.newSetFromMap(new ConcurrentHashMap())).add(queryId);
                ActiveTask activeTask = pendingTask.submit(sessionId);
                this.activeTasks.putIfAbsent(queryId, activeTask);
                return null;
            });
        }
    }

    @EventListener
    public void onSessionUnsubscribe(SessionUnsubscribeEvent event) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String destination = accessor.getDestination();
        if (destination != null && destination.startsWith("/user/topic/sql-results/")) {
            String queryId = destination.substring(destination.lastIndexOf(47) + 1);
            String subscriptionId = accessor.getSubscriptionId();
            String sessionId = accessor.getSessionId();
            log.debug("Unsubscribed: queryId = {} subscriptionId = {} sessionId = {}", new Object[]{queryId, subscriptionId, sessionId});
            this.sessionQueries.computeIfPresent(sessionId, (k, v) -> {
                this.cancelExecution(queryId);
                v.remove(queryId);
                return v;
            });
        }
    }

    @EventListener
    public void onSessionDisconnect(SessionDisconnectEvent event) {
        String sessionId = event.getSessionId();
        this.sessionQueries.computeIfPresent(sessionId, (k, queryIds) -> {
            queryIds.forEach(arg_0 -> this.cancelExecution(arg_0));
            return null;
        });
        log.debug("Disconnected: sessionId = {}, closeStatus = {}", (Object)sessionId, (Object)event.getCloseStatus());
    }

    void cancelExecution(String queryId) {
        ActiveTask removedActiveTask;
        PendingTask pendingTask = (PendingTask)this.pendingTasks.remove(queryId);
        if (pendingTask != null) {
            IteratingSqlRunnable.access$800((IteratingSqlRunnable)PendingTask.access$700((PendingTask)pendingTask)).close();
        }
        if ((removedActiveTask = (ActiveTask)this.activeTasks.remove(queryId)) != null) {
            ActiveTask.access$900((ActiveTask)removedActiveTask).cancel(true);
            ActiveTask.access$1000((ActiveTask)removedActiveTask).close();
        }
    }

    public int pendingTasksSize() {
        return this.pendingTasks.size();
    }

    public int activeTasksSize() {
        return this.activeTasks.size();
    }

    public ConcurrentMap<String, Set<String>> sessionQueries() {
        return this.sessionQueries;
    }

    Set<String> sessionQueries(String sessionId) {
        return Optional.ofNullable((Set)this.sessionQueries.get(sessionId)).orElse(Collections.emptySet());
    }

    @ConstructorProperties(value={"clock", "messagingTemplate", "sqlConfigurationProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SqlRowSetProcessor(Clock clock, SimpMessagingTemplate messagingTemplate, SqlConfigurationProperties sqlConfigurationProperties) {
        this.clock = clock;
        this.messagingTemplate = messagingTemplate;
        this.sqlConfigurationProperties = sqlConfigurationProperties;
    }

    static /* synthetic */ ScheduledExecutorService access$000(SqlRowSetProcessor x0) {
        return x0.iterationPool;
    }

    static /* synthetic */ ConcurrentMap access$100(SqlRowSetProcessor x0) {
        return x0.activeTasks;
    }

    static /* synthetic */ SqlConfigurationProperties access$200(SqlRowSetProcessor x0) {
        return x0.sqlConfigurationProperties;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ ConcurrentMap access$400(SqlRowSetProcessor x0) {
        return x0.sessionQueries;
    }

    static /* synthetic */ SimpMessagingTemplate access$500(SqlRowSetProcessor x0) {
        return x0.messagingTemplate;
    }

    static /* synthetic */ Logger access$600() {
        return DESERIALIZATION_EXCEPTION_LOGGER;
    }

    static /* synthetic */ Clock access$1100(SqlRowSetProcessor x0) {
        return x0.clock;
    }
}

