/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.wan;

import com.google.common.collect.ImmutableMap;
import com.hazelcast.webmonitor.controller.dto.metrics.BaseDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanPublisherMemberDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanPublisherStatsDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanReplicationDTO;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.WanPublisherState;
import com.hazelcast.webmonitor.model.hz.req.state.LocalWanPublisherStats;
import com.hazelcast.webmonitor.service.metrics.MetricsQueryService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class WanReplicationStatsService {
    private static final String OUTBOUND_QUEUE_SIZE = "wan.outboundQueueSize";
    private static final String OUTBOUND_QUEUE_FILL_PERCENT = "wan.queueFillPercent";
    private static final String PUBLISH_LATENCY = "wan.totalPublishLatency";
    private static final String PUBLISHED_EVENTS = "wan.totalPublishedEventCount";
    private static final long LATEST_LOOKUP_INTERVAL_MS = 60000L;
    private final MetricsQueryService metricsQueryService;
    private final Clock clock = Clock.systemDefaultZone();

    public List<WanReplicationDTO> getWanReplications(AllState state, String cluster) {
        SortedSet wanReplications = state.getInstanceNames(InstanceType.WAN_REPLICATION);
        return wanReplications.stream().map(wanRep -> this.getWanReplication(state, cluster, wanRep)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public WanPublisherStatsDTO getWanPublisherStats(AllState state, String cluster, String replication, String publisher) {
        SortedSet wanReplications = state.getInstanceNames(InstanceType.WAN_REPLICATION);
        if (!wanReplications.contains(replication)) {
            throw new NoResourceApiException(replication);
        }
        Map wanPublisherData = state.getWanPublisherData(replication, publisher);
        if (wanPublisherData.isEmpty()) {
            throw new NoResourceApiException(publisher);
        }
        return this.getWanPublisherStatsDTO(wanPublisherData, cluster, replication, publisher, true);
    }

    private WanReplicationDTO getWanReplication(AllState state, String cluster, String wanReplication) {
        Set publishers = state.getInstanceWanPublisherSet(wanReplication);
        if (publishers.isEmpty()) {
            return null;
        }
        List publisherStats = publishers.stream().map(pub -> this.getWanPublisherStatsDTO(state.getWanPublisherData(wanReplication, pub), cluster, wanReplication, pub, false)).collect(Collectors.toList());
        int members = publisherStats.stream().mapToInt(publisherStat -> publisherStat.getMembers().size()).sum();
        WanReplicationDTO.State replicationState = this.determineReplicationState(publisherStats);
        long queuedEvents = this.calculateTotalQueuedEvents(cluster, wanReplication, publisherStats);
        Long maxQueueFillPercent = this.calculateMaxQueueFillPercent(cluster, wanReplication, publisherStats);
        List finalPublisherStats = publisherStats.stream().map(ps -> new WanPublisherStatsDTO(ps.getName(), ps.getState(), null)).collect(Collectors.toList());
        return WanReplicationDTO.builder().name(wanReplication).state(replicationState).members(members).totalQueuedEvents(queuedEvents).maxQueueFillPercent(maxQueueFillPercent).destinations(finalPublisherStats).build();
    }

    private long calculateTotalQueuedEvents(String cluster, String wanReplication, List<WanPublisherStatsDTO> publisherStats) {
        long totalQueuedEvents = 0L;
        for (WanPublisherStatsDTO wanPublisherStatsDTO : publisherStats) {
            Map tags = this.buildTags(wanReplication, wanPublisherStatsDTO.getName());
            MetricDTO metricDTO = MetricDTO.builder().metric(OUTBOUND_QUEUE_SIZE).tags(tags).aggregateBy(MetricDTO.AggregateBy.MEMBERS).aggregate(MetricDTO.Aggregate.SUM).build();
            long publisherQueueSize = this.getMetricValue(cluster, metricDTO).map(BaseDataPointDTO::getValue).map(Long.class::cast).orElse(0L);
            totalQueuedEvents += publisherQueueSize;
        }
        return totalQueuedEvents;
    }

    private Long calculateMaxQueueFillPercent(String cluster, String wanReplication, List<WanPublisherStatsDTO> publisherStats) {
        Long maxPercentage = null;
        for (WanPublisherStatsDTO wanPublisherStatsDTO : publisherStats) {
            Map tags = this.buildTags(wanReplication, wanPublisherStatsDTO.getName());
            MetricDTO metricDTO = MetricDTO.builder().metric(OUTBOUND_QUEUE_FILL_PERCENT).tags(tags).aggregateBy(MetricDTO.AggregateBy.MEMBERS).aggregate(MetricDTO.Aggregate.MAX).build();
            Long publisherMaxPercentage = this.getMetricValue(cluster, metricDTO).map(BaseDataPointDTO::getValue).map(Long.class::cast).orElse(null);
            maxPercentage = (Long)ObjectUtils.max((Comparable[])new Long[]{maxPercentage, publisherMaxPercentage});
        }
        return maxPercentage;
    }

    private WanReplicationDTO.State determineReplicationState(List<WanPublisherStatsDTO> publisherStats) {
        Set states = publisherStats.stream().map(WanPublisherStatsDTO::getState).collect(Collectors.toSet());
        return states.size() > 1 ? WanReplicationDTO.State.MIXED : (WanReplicationDTO.State)states.iterator().next();
    }

    private WanPublisherStatsDTO getWanPublisherStatsDTO(Map<String, LocalWanPublisherStats> wanPublisherData, String cluster, String replication, String publisher, boolean calculateAllMetrics) {
        ArrayList<WanPublisherMemberDTO> memberStats = new ArrayList<WanPublisherMemberDTO>();
        Map tags = this.buildTags(replication, publisher);
        HashSet<WanPublisherState> states = new HashSet<WanPublisherState>();
        for (Map.Entry<String, LocalWanPublisherStats> entry : wanPublisherData.entrySet()) {
            String member = entry.getKey();
            LocalWanPublisherStats localStats = entry.getValue();
            states.add(localStats.getState());
            WanPublisherMemberDTO.WanPublisherMemberDTOBuilder memberStatsBuilder = WanPublisherMemberDTO.builder().member(member).connected(localStats.isConnected()).state(localStats.getState());
            if (calculateAllMetrics) {
                Long outboundQueueSize = this.getMemberMetricValue(cluster, OUTBOUND_QUEUE_SIZE, tags, member, null).map(BaseDataPointDTO::getValue).map(Long.class::cast).orElse(null);
                Long queueFillPercent = this.getMemberMetricValue(cluster, OUTBOUND_QUEUE_FILL_PERCENT, tags, member, null).map(BaseDataPointDTO::getValue).map(Long.class::cast).orElse(null);
                Double eventsPerSecond = this.getMemberMetricValue(cluster, PUBLISHED_EVENTS, tags, member, MetricDTO.Aggregate.DIFF_PER_SEC).map(BaseDataPointDTO::getValue).map(Double.class::cast).orElse(null);
                Double totalLatency = this.getMemberMetricValue(cluster, PUBLISH_LATENCY, tags, member, MetricDTO.Aggregate.DIFF_PER_SEC).map(BaseDataPointDTO::getValue).map(Double.class::cast).orElse(null);
                memberStatsBuilder.outboundQueueSize(outboundQueueSize).outboundQueueFillPercent(queueFillPercent).eventsPerSecond(eventsPerSecond).avgEventLatency(this.calculateAvgLatency(eventsPerSecond, totalLatency));
            }
            memberStats.add(memberStatsBuilder.build());
        }
        WanReplicationDTO.State state = states.size() > 1 ? WanReplicationDTO.State.MIXED : WanReplicationDTO.State.fromWanReplicationState((WanPublisherState)((WanPublisherState)states.iterator().next()));
        return new WanPublisherStatsDTO(publisher, state, memberStats);
    }

    private Double calculateAvgLatency(Double eventsPerSecond, Double totalLatency) {
        if (eventsPerSecond == null || totalLatency == null || totalLatency == 0.0) {
            return null;
        }
        return totalLatency / eventsPerSecond;
    }

    private Optional<BaseDataPointDTO> getMemberMetricValue(String cluster, String metric, Map<String, String> tags, String member, MetricDTO.Aggregate aggregate) {
        MetricDTO metricDTO = MetricDTO.builder().metric(metric).member(member).tags(tags).member(member).aggregate(aggregate).build();
        return this.getMetricValue(cluster, metricDTO);
    }

    private Optional<BaseDataPointDTO> getMetricValue(String cluster, MetricDTO metric) {
        List dataPoint = this.metricsQueryService.queryLatest(cluster, Collections.singletonList(metric), this.clock.millis() - 60000L, this.clock.millis());
        return Optional.ofNullable(dataPoint.isEmpty() ? null : (BaseDataPointDTO)dataPoint.get(0));
    }

    private Map<String, String> buildTags(String replication, String publisher) {
        return ImmutableMap.of((Object)"replication", (Object)replication, (Object)"publisherId", (Object)publisher);
    }

    @ConstructorProperties(value={"metricsQueryService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WanReplicationStatsService(MetricsQueryService metricsQueryService) {
        this.metricsQueryService = metricsQueryService;
    }
}

