/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.wan;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.webmonitor.controller.dto.wan.MapWithWanReplicationDTO;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.utils.InternalObjectsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class WanReplicationConfigService {
    private final MemberConfigService memberConfigService;

    public List<MapWithWanReplicationDTO> getWanReplicatedMaps(String replication, MemberIdentifier masterIdentifier, Collection<String> mapNames) {
        MemberConfig master = this.memberConfigService.getMemberConfig(masterIdentifier);
        Config config = master.toEffectiveConfig();
        if (!config.getWanReplicationConfigs().containsKey(replication)) {
            return Collections.emptyList();
        }
        return mapNames.stream().filter(mapName -> {
            MapConfig mapConfig = config.findMapConfig(mapName);
            WanReplicationRef wanReplicationRef = mapConfig.getWanReplicationRef();
            return wanReplicationRef != null && Objects.equals(replication, wanReplicationRef.getName());
        }).map(mapName -> new MapWithWanReplicationDTO(mapName, InternalObjectsUtil.isInternalObject((String)mapName))).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"memberConfigService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WanReplicationConfigService(MemberConfigService memberConfigService) {
        this.memberConfigService = memberConfigService;
    }
}

