/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import com.hazelcast.webmonitor.service.telemetry.UserLoginEventStoreProvider;
import com.hazelcast.webmonitor.utils.MD5Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class PhoneHomeDataFactory {
    private static final Path DOCKER_FILE_PATH = Paths.get("/.dockerenv", new String[0]);
    private static final Path KUBERNETES_TOKEN_PATH = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]);
    private int counter;
    private final boolean jmxEnabled;
    private final boolean restEnabled;
    private final boolean tlsEnabled;
    private final String tlsMutualAuth;
    private final String serverInfo;
    private final LicenseManager licenseManager;
    private final UserLoginEventStoreProvider userLoginEventStoreProvider;
    private final AuthenticationManagerImpl authenticationManager;
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final List<DataCollector> additionalCollectors;

    public PhoneHomeDataFactory(JMXConfigurationProperties jmxProperties, MCConfigurationProperties mcProperties, String serverInfo, LicenseManager licenseManager, UserLoginEventStoreProvider userLoginEventStoreProvider, AuthenticationManagerImpl authenticationManager, HomeDirectoryProvider homeDirectoryProvider, Collection<DataCollector> additionalCollectors) {
        this.jmxEnabled = jmxProperties.isEnabled();
        this.restEnabled = mcProperties.getRest().isEnabled();
        this.tlsEnabled = mcProperties.getTls().isEnabled();
        this.tlsMutualAuth = this.tlsEnabled ? mcProperties.getTls().getMutualAuthentication() : null;
        this.serverInfo = serverInfo;
        this.licenseManager = licenseManager;
        this.userLoginEventStoreProvider = userLoginEventStoreProvider;
        this.authenticationManager = authenticationManager;
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.additionalCollectors = Collections.unmodifiableList(new ArrayList<DataCollector>(additionalCollectors));
    }

    public PhoneHomeData create() {
        PhoneHomeData phoneHomeData = new PhoneHomeData();
        phoneHomeData.setCount(++this.counter);
        phoneHomeData.setSecurityProvider(this.getSecurityProviderName());
        phoneHomeData.setJavaVersion(System.getProperty("java.version"));
        phoneHomeData.setOs(System.getProperty("os.name"));
        phoneHomeData.setMcVersion(BuildInfo.getFullVersion());
        phoneHomeData.setJmxEnabled(this.jmxEnabled);
        phoneHomeData.setRestEnabled(this.restEnabled);
        phoneHomeData.setTimeTravelEnabled(true);
        phoneHomeData.setApplicationServer(this.serverInfo);
        phoneHomeData.setStandalone(true);
        phoneHomeData.setTlsEnabled(this.tlsEnabled);
        phoneHomeData.setTlsMutualAuth(this.tlsMutualAuth);
        phoneHomeData.setUsers(this.getNumberOfUsers());
        try {
            phoneHomeData.setHomeDirectorySize(this.homeDirectoryProvider.calculateDirectorySize());
        }
        catch (IOException ignored) {
            phoneHomeData.setHomeDirectorySize(0L);
        }
        phoneHomeData.setUptime(Optional.ofNullable(ManagementFactory.getRuntimeMXBean()).map(RuntimeMXBean::getUptime).orElse(0L).longValue());
        phoneHomeData.setLicenseHash(this.licenseManager.isLicenseConfigured() ? MD5Util.toMD5String((String)this.licenseManager.getLicense().getKey()) : null);
        phoneHomeData.setUserLoginEvents(this.userLoginEventStoreProvider.get().drain());
        phoneHomeData.setDockerEnv(this.detectDockerEnv());
        this.additionalCollectors.forEach(collector -> collector.collectInto(phoneHomeData));
        return phoneHomeData;
    }

    private String detectDockerEnv() {
        try {
            DOCKER_FILE_PATH.toRealPath(new LinkOption[0]);
            try {
                KUBERNETES_TOKEN_PATH.toRealPath(new LinkOption[0]);
                return "K";
            }
            catch (IOException e) {
                return "D";
            }
        }
        catch (IOException e) {
            return "N";
        }
    }

    private String getSecurityProviderName() {
        return Optional.ofNullable(this.authenticationManager.getCurrentSecurityProvider()).map(SecurityProvider::getName).orElse(null);
    }

    private int getNumberOfUsers() {
        SecurityProvider provider = this.authenticationManager.getCurrentSecurityProvider();
        return provider instanceof DefaultSecurityProvider ? ((DefaultSecurityProvider)provider).getUsers().size() : 0;
    }
}

