/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.InstanceDataDAO;
import com.hazelcast.webmonitor.security.LoginListener;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageDiagnosticsSupplier;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageDiagnosticsTracker;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.service.prometheus.PrometheusUsageTracker;
import com.hazelcast.webmonitor.service.telemetry.AsyncPhoneHomeLoginListener;
import com.hazelcast.webmonitor.service.telemetry.ClusterUsageTracker;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import com.hazelcast.webmonitor.service.telemetry.FeatureUsageTracker;
import com.hazelcast.webmonitor.service.telemetry.InstanceDataTracker;
import com.hazelcast.webmonitor.service.telemetry.LazyUserLoginEventStoreProvider;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeDataFactory;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeService;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeServiceImpl;
import com.hazelcast.webmonitor.service.telemetry.UserLoginEventStoreProvider;
import java.time.Clock;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"hazelcast.mc.phone.home.enabled"}, matchIfMissing=true)
public class PhoneHomeConfig {
    @Bean
    public PhoneHomeService phoneHomeService(MCConfigurationProperties mcProperties, JMXConfigurationProperties jmxProperties, ServletContext servletContext, LicenseManager licenseManager, UserLoginEventStoreProvider userLoginEventStoreProvider, AuthenticationManagerImpl authenticationManager, HomeDirectoryProvider homeDirectoryProvider, List<DataCollector> additionalCollectors) {
        PhoneHomeDataFactory phoneHomeDataFactory = new PhoneHomeDataFactory(jmxProperties, mcProperties, servletContext.getServerInfo(), licenseManager, userLoginEventStoreProvider, authenticationManager, homeDirectoryProvider, additionalCollectors);
        return new PhoneHomeServiceImpl("http://phonehome.hazelcast.com/pingMc", phoneHomeDataFactory);
    }

    @Bean
    public FeatureUsageTracker featureUsageCounterCollector() {
        return new FeatureUsageTracker();
    }

    @Bean
    public UserLoginEventStoreProvider userLoginEventStoreProvider() {
        return new LazyUserLoginEventStoreProvider();
    }

    @Bean
    public LoginListener phoneHomeLoginListener(UserLoginEventStoreProvider userLoginEventStore) {
        return new AsyncPhoneHomeLoginListener(userLoginEventStore);
    }

    @Bean
    public ClusterUsageTracker clusterUsageTracker(OperationDispatcher operationDispatcher, ClusterManager clusterManager) {
        return new ClusterUsageTracker(operationDispatcher, clusterManager);
    }

    @Bean
    public DataCollector prometheusUsageTracker(PrometheusExporter prometheusExporter, PrometheusExporterConfigurationProperties properties) {
        return new PrometheusUsageTracker(prometheusExporter, properties.isEnabled());
    }

    @Bean
    public MetricsStorageDiagnosticsTracker metricsStorageTracker(MetricsStorageDiagnosticsSupplier diagnosticsDataSupplier) {
        return new MetricsStorageDiagnosticsTracker(diagnosticsDataSupplier);
    }

    @Bean
    public InstanceDataTracker instanceDataTracker(InstanceDataDAO dao) {
        return new InstanceDataTracker(dao, Clock.systemDefaultZone());
    }
}

