/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.webmonitor.model.telemetry.UserLoginRequestRawData;
import com.hazelcast.webmonitor.security.LoginListener;
import com.hazelcast.webmonitor.service.telemetry.UserLoginEventStoreProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPhoneHomeLoginListener
implements LoginListener,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncPhoneHomeLoginListener.class);
    private final UserLoginEventStoreProvider eventStoreProvider;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("PhoneHomeLoginListener-%d").build());

    public void userLoggedIn(HttpServletRequest request) {
        UserLoginRequestRawData userLoginRequestRawData = UserLoginRequestRawData.fromRequest((HttpServletRequest)request);
        this.executor.submit(() -> {
            try {
                this.eventStoreProvider.get().userLoggedIn(userLoginRequestRawData);
            }
            catch (Exception e) {
                log.error("Unexpected Exception when storing user login event", (Throwable)e);
            }
        });
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @ConstructorProperties(value={"eventStoreProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AsyncPhoneHomeLoginListener(UserLoginEventStoreProvider eventStoreProvider) {
        this.eventStoreProvider = eventStoreProvider;
    }
}

