/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.controller.dto.metrics.storage.MetricsStorageDiagnosticsDTO;
import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageDiagnosticsSupplier;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class MetricsStorageDiagnosticsTracker
implements DataCollector {
    private final MetricsStorageDiagnosticsSupplier diagnosticsDataSupplier;

    public void collectInto(PhoneHomeData data) {
        MetricsStorageDiagnosticsDTO diagnostics = this.diagnosticsDataSupplier.get();
        data.setMetricsStorageSize(diagnostics.getStorageSizeInBytes());
        data.setMetricsStorageRetentionSeconds(diagnostics.getPersistentStoreTTLSeconds());
        double metricsDataPointCompressionRate = diagnostics.getDataPointMemoryCompressionRatio();
        if (!Double.isNaN(metricsDataPointCompressionRate)) {
            data.setMetricsDataPointCompressionRate(metricsDataPointCompressionRate);
        }
        data.setMetricsStorageKnownTimeSeries(diagnostics.getKnownTimeSeries());
        data.setMetricsStorageTrackedMinuteBuckets(diagnostics.getTrackedMinuteBuckets());
        data.setMetricsStoragePersistenceRuns(diagnostics.getPersistenceRuns());
        data.setMetricsStorageTotalPersistenceRunTimeInMs(diagnostics.getTotalPersistenceRunTimeInMs());
        data.setMetricsStorageMaxPersistenceRunTimeInMs(diagnostics.getMaxPersistenceRunTimeInMs());
        data.setMetricsStorageAvgPersistenceRunTimeInMs(diagnostics.getAvgPersistenceRunTimeInMs());
        data.setMetricsStorageLastHourAvgPersistenceRunTimeInMs(diagnostics.getLastHourAvgPersistenceRunTimeInMs());
        data.setMetricsStorageTotalPersistedMinuteBuckets(diagnostics.getTotalPersistedMinuteBuckets());
        data.setMetricsStorageMaxPersistedMinuteBucketsPerRun(diagnostics.getMaxPersistedMinuteBucketsPerRun());
        data.setMetricsStorageAvgPersistedMinuteBucketsPerRun(diagnostics.getAvgPersistedMinuteBucketsPerRun());
        data.setMetricsStorageLastHourAvgPersistedMinuteBucketsPerRun(diagnostics.getLastHourAvgPersistedMinuteBucketsPerRun());
        data.setMetricsStorageTotalDroppedDataPoints(diagnostics.getTotalDroppedDataPoints());
        data.setMetricsStorageTotalEvictedDanglingMinuteSeries(diagnostics.getTotalEvictedDanglingMinuteSeries());
    }

    @ConstructorProperties(value={"diagnosticsDataSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsStorageDiagnosticsTracker(MetricsStorageDiagnosticsSupplier diagnosticsDataSupplier) {
        this.diagnosticsDataSupplier = diagnosticsDataSupplier;
    }
}

