/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.model.CounterAggregates;
import com.hazelcast.webmonitor.model.OperationPerformanceAggregates;
import com.hazelcast.webmonitor.service.metrics.AggregateMetricsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MetricsService {
    private final MetricsStorage storage;

    public Optional<DataPointAware> queryLatestRaw(Query query) {
        return this.storage.queryLatest(query);
    }

    public void save(Collection<MetricDataPoint> dataPoints) {
        this.storage.store(dataPoints);
    }

    public OperationPerformanceAggregates computePerformanceAggregates(Query countMetricQuery, Query timeMetricQuery) {
        if (countMetricQuery.getName().equals(timeMetricQuery.getName())) {
            throw new IllegalArgumentException("Queries should be performed for different metrics");
        }
        if (countMetricQuery.getStart() != timeMetricQuery.getStart() || countMetricQuery.getEnd() != timeMetricQuery.getEnd()) {
            throw new IllegalArgumentException("Queries should be in the same time frame");
        }
        return AggregateMetricsUtil.computePerformanceAggregates((DataPointSeries)this.storage.queryRange(countMetricQuery), (DataPointSeries)this.storage.queryRange(timeMetricQuery));
    }

    public CounterAggregates computeCounterAggregates(Query countMetricQuery) {
        DataPointSeries countDataPoints = this.storage.queryRange(countMetricQuery);
        return AggregateMetricsUtil.computeCounterAggregates((DataPointSeries)countDataPoints);
    }

    @ConstructorProperties(value={"storage"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsService(MetricsStorage storage) {
        this.storage = storage;
    }
}

