/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.controller.dto.metrics.BaseDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.controller.exception.FailureApiException;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.imdg.ImdgQueryBuilder;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.metrics.Aggregation;
import com.hazelcast.webmonitor.service.metrics.MetricsQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MetricsQueryService {
    private final MetricsStorage storage;
    private final MemberManager memberManager;
    public static final DataPointMapper<?> LONG_MAPPER = new LongDataPointMapper(null);
    public static final DataPointMapper<?> DOUBLE_MAPPER = new DoubleDataPointMapper(null);

    public MetricsQueryService(MetricsStorage storage, MemberManager memberManager) {
        this.storage = storage;
        this.memberManager = memberManager;
    }

    private <D> List<D> serveRequest(String cluster, List<MetricDTO> metrics, long start, long end, QuerySupplierFactory<D> querySupplierFactory) {
        List members = this.memberManager.getMemberList(cluster);
        ArrayList result = new ArrayList(metrics.size());
        ImdgQueryBuilder queryBuilder = new ImdgQueryBuilder();
        for (MetricDTO metric : metrics) {
            ((ImdgQueryBuilder)queryBuilder.reset().cluster(cluster)).start(start).end(end);
            MetricsQueryService.readFromMetricDTO((ImdgQueryBuilder)queryBuilder, (MetricDTO)metric);
            result.add(querySupplierFactory.create(metric, queryBuilder, members, cluster, this.storage).get());
        }
        return result;
    }

    private static void readFromMetricDTO(ImdgQueryBuilder toBuilder, MetricDTO metric) {
        toBuilder.metric(metric.getMetric());
        if (metric.getMember() != null) {
            toBuilder.member(metric.getMember());
        }
        if (metric.getClient() != null) {
            toBuilder.client(metric.getClient());
        }
        if (metric.getClientName() != null) {
            toBuilder.addTag("clientname", metric.getClientName());
        }
        if (metric.getTags() != null) {
            for (Map.Entry tags : metric.getTags().entrySet()) {
                toBuilder.addTag((String)tags.getKey(), (String)tags.getValue());
            }
        }
    }

    public List<List<BaseDataPointDTO>> queryRange(String cluster, List<MetricDTO> metrics, long start, long end) {
        return this.serveRequest(cluster, metrics, start, end, MetricsQueryService::range);
    }

    public List<BaseDataPointDTO> queryLatest(String cluster, List<MetricDTO> metrics, long start, long end) {
        return this.serveRequest(cluster, metrics, start, end, MetricsQueryService::latest);
    }

    private static Supplier<List<BaseDataPointDTO>> range(MetricDTO metric, ImdgQueryBuilder queryBuilder, List<String> members, String cluster, MetricsStorage storage) {
        return () -> {
            Aggregation aggregation = Aggregation.create((MetricDTO.AggregateBy)metric.getAggregateBy(), (List)members, (String)cluster, (MetricsStorage)storage);
            MetricDTO.Aggregate aggregate = metric.getAggregate();
            DataPointSeries series = aggregation.range(queryBuilder, aggregate);
            DataPointMapper mapper = MetricsQueryService.determineMapper((MetricDTO.Aggregate)aggregate, (DataPointType)series.getType());
            return series.stream().map(arg_0 -> ((DataPointMapper)mapper).map(arg_0)).collect(Collectors.toList());
        };
    }

    private static Supplier<BaseDataPointDTO> latest(MetricDTO metric, ImdgQueryBuilder queryBuilder, List<String> members, String cluster, MetricsStorage storage) {
        return () -> {
            Aggregation aggregation = Aggregation.create((MetricDTO.AggregateBy)metric.getAggregateBy(), (List)members, (String)cluster, (MetricsStorage)storage);
            MetricDTO.Aggregate aggregate = metric.getAggregate();
            Optional latest = aggregation.latest(queryBuilder, aggregate);
            return latest.map(dataPoint -> {
                DataPointMapper mapper = MetricsQueryService.determineMapper((MetricDTO.Aggregate)aggregate, (DataPointType)dataPoint.getType());
                return mapper.map(dataPoint);
            }).orElse(null);
        };
    }

    private static DataPointMapper<?> determineMapper(MetricDTO.Aggregate aggregate, DataPointType type) {
        if (aggregate == null) {
            return MetricsQueryService.fromType((DataPointType)type);
        }
        switch (1.$SwitchMap$com$hazelcast$webmonitor$controller$dto$metrics$MetricDTO$Aggregate[aggregate.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return MetricsQueryService.fromType((DataPointType)type);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return DOUBLE_MAPPER;
            }
        }
        throw new FailureApiException("Unsupported aggregate value: " + aggregate);
    }

    private static DataPointMapper<?> fromType(DataPointType type) {
        switch (1.$SwitchMap$com$hazelcast$webmonitor$metrics$DataPointType[type.ordinal()]) {
            case 1: {
                return LONG_MAPPER;
            }
            case 2: {
                return DOUBLE_MAPPER;
            }
        }
        throw new IllegalArgumentException("No mapper for " + type);
    }
}

