/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.service.metrics.GroupByAggregator;
import com.hazelcast.webmonitor.service.metrics.MetricType;

final class AvgAggregator
extends GroupByAggregator {
    AvgAggregator() {
    }

    public DataPointSeries compute() {
        if (this.aggregatedSeries.isEmpty()) {
            return DataPointSeries.empty();
        }
        long[] times = this.unionTimePoints();
        long[] values = new long[times.length];
        for (DataPointSeries series : this.aggregatedSeries) {
            this.combineSeries(series, times, values);
        }
        int size = this.aggregatedSeries.size();
        MetricType type = MetricType.from((DataPointType)this.dataPointType);
        for (int i = 0; i < values.length; ++i) {
            values[i] = type.avg(values[i], size);
        }
        return new DataPointSeries(times, values, DataPointType.DOUBLE);
    }

    protected void combinePoint(long[] dest, int index, long value) {
        int n = index;
        dest[n] = dest[n] + value;
    }
}

