/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.model.CounterAggregates;
import com.hazelcast.webmonitor.model.OperationPerformanceAggregates;
import com.hazelcast.webmonitor.service.exception.DataPointSeriesMismatchException;
import java.util.Iterator;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AggregateMetricsUtil {
    private static final int MS_IN_SEC = 1000;

    private AggregateMetricsUtil() {
    }

    public static OperationPerformanceAggregates computePerformanceAggregates(DataPointSeries counterSeries, DataPointSeries latencySeries) {
        if (counterSeries.size() == 0 || counterSeries.size() != latencySeries.size()) {
            throw new DataPointSeriesMismatchException("Metrics data points have different number of records");
        }
        Iterator countMetricDataPoints = counterSeries.iterator();
        Iterator timeMetricDataPoints = latencySeries.iterator();
        DataPointAware countMetricDataPoint = (DataPointAware)countMetricDataPoints.next();
        DataPointAware timeMetricDataPoint = (DataPointAware)timeMetricDataPoints.next();
        AggregateMetricsUtil.checkDataPointsHaveSameTimestamp((DataPointAware)countMetricDataPoint, (DataPointAware)timeMetricDataPoint);
        long start = countMetricDataPoint.getTime();
        long end = countMetricDataPoint.getTime();
        long countMetricDiff = 0L;
        long countMetricPrev = countMetricDataPoint.getValue();
        long timeMetricDiff = 0L;
        long timeMetricPrev = timeMetricDataPoint.getValue();
        double highestAvgLatency = 0.0;
        while (countMetricDataPoints.hasNext() && timeMetricDataPoints.hasNext()) {
            countMetricDataPoint = (DataPointAware)countMetricDataPoints.next();
            timeMetricDataPoint = (DataPointAware)timeMetricDataPoints.next();
            AggregateMetricsUtil.checkDataPointsHaveSameTimestamp((DataPointAware)countMetricDataPoint, (DataPointAware)timeMetricDataPoint);
            long countMetricValue = countMetricDataPoint.getValue();
            countMetricDiff += countMetricValue - countMetricPrev;
            long timeMetricValue = timeMetricDataPoint.getValue();
            timeMetricDiff += timeMetricValue - timeMetricPrev;
            if (countMetricValue - countMetricPrev < 0L) {
                countMetricDiff = 0L;
                timeMetricDiff = 0L;
                start = countMetricDataPoint.getTime();
            }
            countMetricPrev = countMetricValue;
            timeMetricPrev = timeMetricValue;
            highestAvgLatency = Math.max(highestAvgLatency, countMetricDiff == 0L ? 0.0 : (double)timeMetricDiff / (double)countMetricDiff);
            end = countMetricDataPoint.getTime();
        }
        long interval = (end - start) / 1000L;
        return new OperationPerformanceAggregates(highestAvgLatency, countMetricDiff == 0L ? 0.0 : (double)timeMetricDiff / (double)countMetricDiff, interval == 0L ? 0.0 : (double)countMetricDiff / (double)interval);
    }

    private static void checkDataPointsHaveSameTimestamp(DataPointAware pointOne, DataPointAware pointTwo) {
        if (pointOne.getTime() != pointTwo.getTime()) {
            throw new DataPointSeriesMismatchException("Metrics data points have different timestamps");
        }
    }

    public static CounterAggregates computeCounterAggregates(DataPointSeries counterSeries) {
        Iterator countMetricDataPoints = counterSeries.iterator();
        if (!countMetricDataPoints.hasNext()) {
            return CounterAggregates.EMPTY;
        }
        DataPointAware countMetricDataPoint = (DataPointAware)countMetricDataPoints.next();
        long start = countMetricDataPoint.getTime();
        long end = countMetricDataPoint.getTime();
        long startValue = countMetricDataPoint.getValue();
        long endValue = countMetricDataPoint.getValue();
        long countMetricPrev = countMetricDataPoint.getValue();
        while (countMetricDataPoints.hasNext()) {
            countMetricDataPoint = (DataPointAware)countMetricDataPoints.next();
            long countMetricValue = countMetricDataPoint.getValue();
            if (countMetricValue - countMetricPrev < 0L) {
                start = countMetricDataPoint.getTime();
                startValue = countMetricValue;
            }
            countMetricPrev = countMetricValue;
            end = countMetricDataPoint.getTime();
            endValue = countMetricValue;
        }
        long interval = (end - start) / 1000L;
        double throughput = interval == 0L ? 0.0 : (double)(endValue - startValue) / (double)interval;
        long increment = endValue - startValue;
        return new CounterAggregates(throughput, increment);
    }

    public static long interpolate(long second, DataPointAware prev, DataPointAware next) {
        double fraction = (double)(second - prev.getTime()) / (double)(next.getTime() - prev.getTime());
        long v1 = prev.getValue();
        long v2 = next.getValue();
        return (long)((double)v1 + (double)(v2 - v1) * fraction);
    }
}

