/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.google.common.base.Suppliers;
import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.exception.ConfigParseException;
import com.hazelcast.webmonitor.service.memberconfig.ConfigXmlParser;
import com.hazelcast.webmonitor.service.memberconfig.InstrumentedMemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.ParsedMemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.XmlParsingTimeListener;
import com.hazelcast.webmonitor.utils.XmlUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MemberConfig {
    private final String rawXmlConfig;
    private final Supplier<Config> effectiveConfig;
    private final Supplier<ParsedMemberConfig> parsedConfig;

    public MemberConfig(@Nonnull String rawXmlConfig) {
        this.rawXmlConfig = rawXmlConfig;
        String processedXmlConfig = XmlUtil.maskXPathExpressionsInXml((String)rawXmlConfig, (String)"none", Collections.singletonList("/hazelcast/security/realms/realm/identity/token/@encoding"));
        this.effectiveConfig = Suppliers.memoize(() -> this.doParseXml(processedXmlConfig));
        this.parsedConfig = Suppliers.memoize(() -> {
            try {
                return new ConfigXmlParser((Config)this.effectiveConfig.get()).parse();
            }
            catch (InvalidConfigurationException e) {
                throw new ConfigParseException((Throwable)e);
            }
        });
    }

    protected Config doParseXml(String xmlConfig) {
        return new SchemaIgnoringXmlConfigBuilder(new ByteArrayInputStream(xmlConfig.getBytes(StandardCharsets.UTF_8))).build();
    }

    public String getRawXmlConfig() {
        return this.rawXmlConfig;
    }

    public ParsedMemberConfig parse() {
        return (ParsedMemberConfig)this.parsedConfig.get();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberConfig)) {
            return false;
        }
        MemberConfig that = (MemberConfig)o;
        return Objects.equals(this.rawXmlConfig, that.rawXmlConfig);
    }

    public final int hashCode() {
        return Objects.hash(this.rawXmlConfig);
    }

    public Config toEffectiveConfig() {
        return (Config)this.effectiveConfig.get();
    }

    InstrumentedMemberConfig instrument(XmlParsingTimeListener listener, Clock clock, MemberIdentifier owner) {
        return new InstrumentedMemberConfig(this.rawXmlConfig, listener, clock, owner);
    }
}

