/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jet;

import com.hazelcast.jet.Job;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.webmonitor.controller.dto.jet.DagDTO;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.metrics.jet.JetClusterMetricsStore;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.jet.BaseJetManager;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJetManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJetManager.class);
    protected final MCClientManager clientManager;
    protected final JetMetricsService jetMetricsService;
    protected final Clock clock;

    public BaseJetManager(MCClientManager clientManager, JetMetricsService jetMetricsService, Clock clock) {
        this.clientManager = clientManager;
        this.jetMetricsService = jetMetricsService;
        this.clock = clock;
    }

    protected MCClient clientFor(String cluster) {
        return this.clientManager.clientFor(cluster);
    }

    protected JetClusterMetricsStore storeFor(JobIdentifier job) {
        return this.storeFor(job.cluster);
    }

    protected JetClusterMetricsStore storeFor(String cluster) {
        return this.jetMetricsService.getStore(cluster);
    }

    protected Job getJob(JobIdentifier jobIdentifier) {
        MCClient client = this.clientFor(jobIdentifier.cluster);
        Job job = client.getHzClient().getJet().getJob(jobIdentifier.id);
        if (job == null || job.isLightJob()) {
            throw new NoResourceApiException("Job with id -> " + jobIdentifier.id);
        }
        return job;
    }

    protected String getLastExecutionId(JobIdentifier job) {
        JetClusterMetricsStore store = this.jetMetricsService.getStore(job.cluster);
        try {
            return store.query("queuesSize", (TagExpression)TagExpressions.tagEquals((String)"job", (String)job.idString)).max(Comparator.comparingLong(TimeSeries::getLatestTime)).map(ts -> (String)ts.tags().get("exec")).orElse(null);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to get last execution ID for job: {}", (Object)job, (Object)e);
            return null;
        }
    }

    protected DagDTO getDag(JobIdentifier job, String lastExecutionId, JobRecord jobRecord) {
        DagDTO dag = (DagDTO)SerializationUtil.OBJECT_MAPPER.readValue(jobRecord.getDagJson(), DagDTO.class);
        if (lastExecutionId != null) {
            JetClusterMetricsStore store = this.storeFor(job);
            List vertices = dag.getVertices();
            for (DagDTO.VertexDTO vertex : vertices) {
                long parallelism = store.query("queuesSize", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)job.idString), TagExpressions.tagEquals((String)"vertex", (String)vertex.getName()), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId)})).count();
                vertex.setGlobalParallelism((int)parallelism);
            }
        }
        return dag;
    }
}

