/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.events.model.ConfigUpdateFinishedEvent;
import com.hazelcast.webmonitor.events.model.ConfigUpdateStartedEvent;
import com.hazelcast.webmonitor.networking.URLFactory;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.BrowserHeartBeatEvent;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.context.event.EventListener;

class PeriodicHealthCheckRunner {
    public static final PeriodicHealthCheckRunner DISABLED = new /* Unavailable Anonymous Inner Class!! */;
    private static final int FREQUENCY_LIMIT_SECONDS = 5;
    private final HealthCheckService healthCheckService;
    private final Notifier notifier;
    private final ScheduledExecutorService executor;
    private final URLFactory urlFactory;
    private final ConcurrentHashMap<String, Boolean> healthCheckIsScheduledForCluster = new ConcurrentHashMap();
    private final Cache<String, Boolean> dynamicConfigUpdateStatePerCluster = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();

    @EventListener
    @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"})
    public void browserHeartBeat(BrowserHeartBeatEvent event) {
        String cluster = event.getCluster();
        if (this.healthCheckIsScheduledForCluster.put(cluster, true) != Boolean.TRUE) {
            this.executor.schedule(() -> {
                if (Boolean.FALSE.equals(this.dynamicConfigUpdateStatePerCluster.get((Object)cluster, __ -> Boolean.FALSE))) {
                    this.evaluateOutcomes(this.healthCheckService.analyze(cluster), cluster);
                }
                this.healthCheckIsScheduledForCluster.put(cluster, false);
            }, 5L, TimeUnit.SECONDS);
        }
    }

    private void evaluateOutcomes(List<AnalysisOutcome> outcomes, String cluster) {
        int problemCount = outcomes.stream().mapToInt(outcome -> outcome.getIdentifiedProblems().size()).sum();
        if (problemCount == 0) {
            return;
        }
        String linkHref = this.urlFactory.resolve("/clusters/" + cluster + "/healthcheck");
        String linkText = problemCount + (problemCount == 1 ? " problem" : " problems");
        String message = String.format("Config Healthcheck found <a href=\"%s\">%s</a>", linkHref, linkText);
        this.notifier.signal(Note.Matter.HEALTHCHECK_PROBLEMS_FOUND.on(cluster, message));
    }

    @EventListener
    public void configUpdateStarted(ConfigUpdateStartedEvent event) {
        this.dynamicConfigUpdateStatePerCluster.put((Object)event.memberIdent().getClusterName(), (Object)true);
    }

    @EventListener
    public void configUpdateFinished(ConfigUpdateFinishedEvent event) {
        this.dynamicConfigUpdateStatePerCluster.put((Object)event.memberIdent().getClusterName(), (Object)false);
    }

    @ConstructorProperties(value={"healthCheckService", "notifier", "executor", "urlFactory"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PeriodicHealthCheckRunner(HealthCheckService healthCheckService, Notifier notifier, ScheduledExecutorService executor, URLFactory urlFactory) {
        this.healthCheckService = healthCheckService;
        this.notifier = notifier;
        this.executor = executor;
        this.urlFactory = urlFactory;
    }
}

