/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.PercentageUtils;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMemorySizeAnalyzer
implements Analyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NativeMemorySizeAnalyzer.class);
    public static final String USED_NATIVE_MEMORY_METRIC_NAME = "memory.usedNative";
    private final MemberConfigSupplier memberConfigs;
    private final MemberMetricsSupplier memberMetricSupplier;

    public AnalysisOutcome analyze(SourceDataFilter filter) {
        List warnings = filter.filter((Map)this.memberMetricSupplier.get()).entrySet().stream().map(memberIdentifierToMetricsMapEntry -> {
            MemberIdentifier memberIdentifier = (MemberIdentifier)memberIdentifierToMetricsMapEntry.getKey();
            MemberConfig memberConfig = (MemberConfig)((MemberConfigMap)this.memberConfigs.get()).get((Object)memberIdentifier);
            List metrics = (List)memberIdentifierToMetricsMapEntry.getValue();
            if (memberConfig == null || metrics == null) {
                return Collections.emptyList();
            }
            NativeMemoryConfig nativeMemoryConfig = memberConfig.toEffectiveConfig().getNativeMemoryConfig();
            return metrics.stream().map(metricDataPoint -> this.getMemberProblem(memberIdentifier, metricDataPoint.getValue(), nativeMemoryConfig.getCapacity().bytes())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        return AnalysisOutcome.warning((String)this.describeSelf(), warnings);
    }

    private Optional<MemberProblem> getMemberProblem(MemberIdentifier memberIdentifier, long usedNativeMemory, long maxNativeMemory) {
        log.debug("Member {} has max native memory size vs used native memory size {}<>{}", new Object[]{memberIdentifier, maxNativeMemory, usedNativeMemory});
        if (usedNativeMemory > maxNativeMemory) {
            String message = String.format("Used native memory size %,d bytes is greater than the maximum native memory size %,d bytes (over by %%%,.1f)", usedNativeMemory, maxNativeMemory, PercentageUtils.calculateExcessInPercentage((long)usedNativeMemory, (long)maxNativeMemory));
            log.debug(message);
            return Optional.of(new MemberProblem(message, "Please set the maximum native memory size to a greater value in your configuration", memberIdentifier));
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return "Checking if member maximum native memory size is valid";
    }

    @ConstructorProperties(value={"memberConfigs", "memberMetricSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public NativeMemorySizeAnalyzer(MemberConfigSupplier memberConfigs, MemberMetricsSupplier memberMetricSupplier) {
        this.memberConfigs = memberConfigs;
        this.memberMetricSupplier = memberMetricSupplier;
    }
}

