/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.networking.URLFactory;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.repositories.sql.HealthCheckIgnoreListDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerConfig;
import com.hazelcast.webmonitor.service.healthcheck.DefaultHealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.DefaultSourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.EventPublishingHealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckListener;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckMetricsCollector;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.MemberListDataSource;
import com.hazelcast.webmonitor.service.healthcheck.PeriodicHealthCheckRunner;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.core.context.SecurityContextHolder;

@Configuration
@Import(value={AnalyzerConfig.class})
public class HealthCheckConfig {
    private static final int MAX_THREAD_COUNT = 4;
    private final URLFactory urlFactory;
    private final Jdbi jdbi;
    private final SecurityConfigurationManager securityConfigManager;
    private final MemberListDataSource memberListDataSource;
    private final MemberConfigService memberConfigService;

    @Bean
    public SourceDataSubscriptionPool sourceDataSubscriptionPool(HealthCheckMetricsCollector metricsCollector) {
        return new DefaultSourceDataSubscriptionPool(() -> ((MemberConfigService)this.memberConfigService).asMap(), this.memberListDataSource, metricsCollector);
    }

    @Bean
    HealthCheckMetricsCollector metricsCollector() {
        return new HealthCheckMetricsCollector();
    }

    @Bean
    public EventPublishingHealthCheckService eventPublishingHealthCheckService(HealthCheckService healthCheckService, List<HealthCheckListener> listeners) {
        return new EventPublishingHealthCheckService(healthCheckService, listeners);
    }

    @Bean
    HealthCheckIgnoreListDAO ignoreListDAO() {
        return new HealthCheckIgnoreListDAO(this.jdbi);
    }

    @Bean
    HealthCheckService healthCheckService(List<AnalysisOutcomeSource> analyzers) {
        return new DefaultHealthCheckService(analyzers, this.ignoreListDAO(), this.loggedInUserNameProvider());
    }

    Supplier<String> loggedInUserNameProvider() {
        return () -> {
            if ("Dev Mode".equals(this.securityConfigManager.getCurrentSecurityProviderName())) {
                return null;
            }
            return SecurityContextHolder.getContext().getAuthentication().getName();
        };
    }

    @Bean
    public PeriodicHealthCheckRunner periodicRunner(List<AnalysisOutcomeSource> analyzers, Notifier notifier, MCConfigurationProperties mcProperties) {
        if (!mcProperties.getInternal().isCloud() && mcProperties.isPeriodicHealthCheckEnabled()) {
            return new PeriodicHealthCheckRunner(this.healthCheckService(analyzers), notifier, Executors.newScheduledThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), 4)), this.urlFactory);
        }
        return PeriodicHealthCheckRunner.DISABLED;
    }

    @ConstructorProperties(value={"urlFactory", "jdbi", "securityConfigManager", "memberListDataSource", "memberConfigService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthCheckConfig(URLFactory urlFactory, Jdbi jdbi, SecurityConfigurationManager securityConfigManager, MemberListDataSource memberListDataSource, MemberConfigService memberConfigService) {
        this.urlFactory = urlFactory;
        this.jdbi = jdbi;
        this.securityConfigManager = securityConfigManager;
        this.memberListDataSource = memberListDataSource;
        this.memberConfigService = memberConfigService;
    }
}

