/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

abstract class EqualityAnalyzer
implements Analyzer {
    protected final MemberConfigSupplier memberConfigs;

    public final AnalysisOutcome analyze(SourceDataFilter filter) {
        ArrayList problems = new ArrayList();
        filter.filter((MemberConfigMap)this.memberConfigs.get()).groupByCluster().forEach((clusterName, memberConfigs) -> {
            Map<MemberIdentifier, Config> effectiveConfigs = memberConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MemberConfig)entry.getValue()).toEffectiveConfig()));
            effectiveConfigs.forEach((member, config) -> config.getMapConfigs().forEach((name, mapCfg) -> {
                if (mapCfg.getNearCacheConfig() != null && mapCfg.getNearCacheConfig().getName() == null) {
                    mapCfg.getNearCacheConfig().setName("");
                }
            }));
            problems.addAll(this.analyze(effectiveConfigs));
        });
        return AnalysisOutcome.success((String)this.describeSelf(), problems);
    }

    protected <Attr> Map<MemberIdentifier, Attr> extractConfigAttribute(Map<MemberIdentifier, Config> effectiveConfigs, Function<Config, Attr> attributeExtractor) {
        HashMap groupsByValues = new HashMap();
        effectiveConfigs.forEach((member, config) -> groupsByValues.put(member, attributeExtractor.apply((Config)config)));
        return groupsByValues;
    }

    protected abstract List<Problem> analyze(Map<MemberIdentifier, Config> var1);

    @ConstructorProperties(value={"memberConfigs"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EqualityAnalyzer(MemberConfigSupplier memberConfigs) {
        this.memberConfigs = memberConfigs;
    }
}

