/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.CacheEntryListenerEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheEntryListenerEquivalence
extends ListEquivalence<CacheSimpleConfig, CacheSimpleEntryListenerConfig, String> {
    private final String cacheName;

    CacheEntryListenerEquivalence(Map<MemberIdentifier, Config> memberConfigs, String cacheName) {
        super(memberConfigs, true);
        this.cacheName = cacheName;
    }

    AttributeEquivalence<CacheSimpleEntryListenerConfig> createElementAttributeEquivalence(String elemId, Map<CacheSimpleEntryListenerConfig, Set<MemberIdentifier>> groupsByValues) {
        return new CacheEntryListenerAttributeEquivalence(groupsByValues, String.format("entry listener %s of cache %s", elemId, this.cacheName));
    }

    MemberComparisonProblem createProblemForMissingElement(String elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.builder().description(String.format("Cache entry listener %s of cache %s is inconsistently configured across members", elemId, this.cacheName)).advice(String.format("Set the same cache-entry-listeners list for cache %s in all member configurations", this.cacheName)).addOutlierGroup(OutlierGroup.of((String)(elemId + " is configured"), membersContainingTheElem)).addOutlierGroup(OutlierGroup.of((String)(elemId + " is missing"), membersMissingTheElem)).build();
    }

    CacheSimpleConfig extractOwner(Config config) {
        return config.findCacheConfig(this.cacheName);
    }

    Map<String, CacheSimpleEntryListenerConfig> extractElements(CacheSimpleConfig owner) {
        List cacheEntryListeners = owner.getCacheEntryListeners();
        HashMap<String, CacheSimpleEntryListenerConfig> rval = new HashMap<String, CacheSimpleEntryListenerConfig>(cacheEntryListeners.size());
        cacheEntryListeners.forEach(entryListener -> rval.put(entryListener.getCacheEntryListenerFactory(), (CacheSimpleEntryListenerConfig)entryListener));
        return rval;
    }
}

