/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import com.hazelcast.client.Client;
import com.hazelcast.client.impl.ClientSelector;
import com.hazelcast.client.impl.ClientSelectors;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListEntryDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringTestDeployDTO;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListEntryModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListEntryType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ClientFilteringUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientFilteringUtil.class);
    private static final String WILDCARD = "*";
    private static final String RANGE_SYMBOL = "-";
    private static final String IPV4_SEPARATOR = ".";
    private static final String IPV6_SEPARATOR = ":";
    private static final int HEX_RADIX = 16;
    public static final Comparator<String> STRING_WITH_WILDCARD_COMPARATOR = (a, b) -> {
        int aWildcard = a.indexOf("*");
        int bWildcard = b.indexOf("*");
        if (aWildcard != -1 && bWildcard == -1) {
            return -1;
        }
        if (aWildcard == -1 && bWildcard != -1) {
            return 1;
        }
        if (aWildcard != -1) {
            return aWildcard - bWildcard;
        }
        return a.compareTo((String)b);
    };
    public static final Comparator<String> IP_COMPARATOR = (a, b) -> {
        if (!a.contains(":") && b.contains(":")) {
            return -1;
        }
        if (a.contains(":") && !b.contains(":")) {
            return 1;
        }
        if (a.contains("*") && !b.contains("*")) {
            return -1;
        }
        if (!a.contains("*") && b.contains("*")) {
            return 1;
        }
        if (a.contains("-") && !b.contains("-")) {
            return -1;
        }
        if (!a.contains("-") && b.contains("-")) {
            return 1;
        }
        String[] aOct = ClientFilteringUtil.splitIpToParts((String)a);
        String[] bOct = ClientFilteringUtil.splitIpToParts((String)b);
        for (int i = 0; i < aOct.length; ++i) {
            int b2;
            int b1 = ClientFilteringUtil.parseIntFromIpPart((String)aOct[i]);
            if (b1 == (b2 = ClientFilteringUtil.parseIntFromIpPart((String)bOct[i]))) continue;
            return b1 < b2 ? -1 : 1;
        }
        return 0;
    };

    private ClientFilteringUtil() {
    }

    public static Map<ClientFilteringListEntryType, List<String>> groupByTypeAndSortEntries(List<ClientFilteringListEntryDTO> rules) {
        Map<ClientFilteringListEntryType, List<String>> result = rules.stream().collect(Collectors.groupingBy(ClientFilteringListEntryDTO::getType, Collectors.mapping(ClientFilteringListEntryDTO::getValue, Collectors.toList())));
        result.replaceAll(ClientFilteringUtil::sortEntries);
        return result;
    }

    public static ClientFilteringTestDeployDTO testDeploy(ClientFilteringListType type, List<ClientFilteringListEntryModel> entries, Collection<ClientEndPointDTO> clients) {
        ClientSelector selector = ClientFilteringUtil.createSelector((ClientFilteringListType)type, entries);
        ArrayList<ClientEndPointDTO> allowedClients = new ArrayList<ClientEndPointDTO>();
        ArrayList<ClientEndPointDTO> deniedClients = new ArrayList<ClientEndPointDTO>();
        for (ClientEndPointDTO client : clients) {
            if ("MCJVM".equals(client.getClientType())) continue;
            ClientForSelector clientForSelector = ClientForSelector.builder().address(client.getAddress()).name(client.getName()).labels((Set)client.getLabels()).build();
            if (selector.select((Client)clientForSelector)) {
                allowedClients.add(client);
                continue;
            }
            deniedClients.add(client);
        }
        return new ClientFilteringTestDeployDTO(allowedClients, deniedClients);
    }

    private static List<String> sortEntries(ClientFilteringListEntryType type, List<String> values) {
        return values.stream().distinct().sorted(ClientFilteringUtil.getComparator((ClientFilteringListEntryType)type)).collect(Collectors.toList());
    }

    private static Comparator<String> getComparator(ClientFilteringListEntryType type) {
        return type == ClientFilteringListEntryType.IP_ADDRESS ? IP_COMPARATOR : STRING_WITH_WILDCARD_COMPARATOR;
    }

    private static String[] splitIpToParts(String a) {
        return a.replaceAll("[-][0-9a-f]*", "").replaceAll("[*]", "-2").replaceAll(":", ".").split("\\.");
    }

    private static int parseIntFromIpPart(String ipPart) {
        try {
            return Integer.parseInt(ipPart, 16);
        }
        catch (Exception e) {
            log.warn("Can't parse integer from IP address part {}", (Object)ipPart);
            return 0;
        }
    }

    private static ClientSelector createSelector(ClientFilteringListType type, List<ClientFilteringListEntryModel> entries) {
        ClientSelector selector = ClientSelectors.none();
        for (ClientFilteringListEntryModel entry : entries) {
            ClientSelector entrySelector = ClientFilteringUtil.createSelector((ClientFilteringListEntryModel)entry);
            selector = ClientSelectors.or((ClientSelector[])new ClientSelector[]{selector, entrySelector});
        }
        return type == ClientFilteringListType.ALLOWLIST ? selector : ClientSelectors.inverse((ClientSelector)selector);
    }

    private static ClientSelector createSelector(ClientFilteringListEntryModel entry) {
        switch (1.$SwitchMap$com$hazelcast$webmonitor$model$sql$client$ClientFilteringListEntryType[entry.getType().ordinal()]) {
            case 1: {
                return ClientSelectors.ipSelector((String)entry.getValue());
            }
            case 2: {
                return ClientSelectors.nameSelector((String)ClientFilteringUtil.sanitizeValueWithWildcards((String)entry.getValue()));
            }
            case 3: {
                return ClientSelectors.labelSelector((String)ClientFilteringUtil.sanitizeValueWithWildcards((String)entry.getValue()));
            }
        }
        throw new IllegalArgumentException("Unknown client filtering list entry type: " + entry.getType());
    }

    private static String sanitizeValueWithWildcards(String value) {
        String quoted = Pattern.quote(value);
        return quoted.replaceAll("\\*", "\\\\E.*\\\\Q");
    }
}

