/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.controller.exception.NoMemberApiException;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.controller.exception.TimeoutException;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.utils.CompletableFutureUtil;
import com.hazelcast.webmonitor.utils.MemberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OperationDispatcher {
    private final MCClientManager clientManager;
    private final long clusterOperationTimeoutMillis;

    public OperationDispatcher(MCClientManager clientManager, MCConfigurationProperties mcProperties) {
        this.clientManager = clientManager;
        this.clusterOperationTimeoutMillis = mcProperties.getClusterOperationTimeout().toMillis();
    }

    private static <T> T wrapException(Callable<T> task, Function<Exception, String> errorMessageConstructor) {
        try {
            return task.call();
        }
        catch (Exception e) {
            throw new OperationFailedApiException(errorMessageConstructor.apply(e), (Throwable)e);
        }
    }

    public <T> T executeOnCluster(String clusterName, Function<MCClient, CompletableFuture<T>> operation, Function<Exception, String> errorMessageConstructor) {
        return (T)OperationDispatcher.wrapException(() -> ((CompletableFuture)operation.apply(this.getMCClient(clusterName))).get(this.clusterOperationTimeoutMillis, TimeUnit.MILLISECONDS), errorMessageConstructor);
    }

    public <T> CompletableFuture<T> executeOnClusterAsync(String clusterName, Function<MCClient, CompletableFuture<T>> operation, Function<Exception, String> errorMessageConstructor) {
        return (CompletableFuture)OperationDispatcher.wrapException(() -> (CompletableFuture)operation.apply(this.getMCClient(clusterName)), errorMessageConstructor);
    }

    public <T> T executeOnMember(MemberIdentifier memberIdent, BiFunction<MCClient, Member, CompletableFuture<T>> operation, Function<Exception, String> errorMessageConstructor) {
        return (T)OperationDispatcher.wrapException(() -> {
            MCClient client = this.getMCClient(memberIdent.getClusterName());
            Member member = this.getMember(memberIdent.getMemberAddress(), client.getHzClient());
            return ((CompletableFuture)operation.apply(client, member)).get(this.clusterOperationTimeoutMillis, TimeUnit.MILLISECONDS);
        }, errorMessageConstructor);
    }

    public <T> CompletableFuture<T> asyncExecuteOnMember(MemberIdentifier memberIdent, BiFunction<MCClient, Member, CompletableFuture<T>> operation) {
        MCClient client = this.getMCClient(memberIdent.getClusterName());
        Member member = this.getMember(memberIdent.getMemberAddress(), client.getHzClient());
        return operation.apply(client, member);
    }

    protected <T> Collection<T> executeOnAllMembers(String cluster, BiFunction<MCClient, Member, CompletableFuture<T>> operation, BiFunction<Member, Throwable, T> errorMapperFn) {
        return (Collection)OperationDispatcher.wrapException(() -> {
            MCClient mcClient = this.getMCClient(cluster);
            List members = this.getMembers(mcClient);
            ArrayList<CompletionStage> operations = new ArrayList<CompletionStage>();
            for (Member member : members) {
                operations.add(((CompletableFuture)operation.apply(mcClient, member)).exceptionally(t -> errorMapperFn.apply(member, (Throwable)t)));
            }
            return CompletableFutureUtil.returnWithDeadline(operations, (index, ex) -> {
                Member member = (Member)members.get((int)index);
                return errorMapperFn.apply(member, (Throwable)new TimeoutException((Throwable)ex, cluster, member));
            }, (long)this.clusterOperationTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }, (T e) -> "Could not execute operation on members");
    }

    public <T> Collection<T> executeOnMemberAddresses(String cluster, Set<String> memberAddresses, BiFunction<MCClient, Member, CompletableFuture<T>> operation, BiFunction<Member, Throwable, T> errorMapperFn) {
        return (Collection)OperationDispatcher.wrapException(() -> {
            MCClient client = this.getMCClient(cluster);
            HazelcastInstance hzClient = client.getHzClient();
            List members = memberAddresses.stream().map(it -> this.getMember(it, hzClient)).collect(Collectors.toList());
            ArrayList<CompletionStage> operations = new ArrayList<CompletionStage>();
            for (Member member : members) {
                operations.add(((CompletableFuture)operation.apply(client, member)).exceptionally(t -> errorMapperFn.apply(member, (Throwable)t)));
            }
            return CompletableFutureUtil.returnWithDeadline(operations, (index, ex) -> errorMapperFn.apply((Member)members.get((int)index), (Throwable)new TimeoutException((Throwable)ex, cluster, (Member)members.get((int)index))), (long)this.clusterOperationTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }, (T e) -> "Could not execute operation on members");
    }

    public <T> Optional<T> executeOnMembersSequentiallyUntilFirstResult(String cluster, List<Member> members, BiFunction<MCClient, Member, CompletableFuture<T>> operation, Function<Throwable, String> errorMsgMapperFn) {
        try {
            MCClient mcClient = this.getMCClient(cluster);
            for (Member member : members) {
                CompletableFuture<T> future = operation.apply(mcClient, member);
                T result = future.get(this.clusterOperationTimeoutMillis, TimeUnit.MILLISECONDS);
                if (result == null) continue;
                return Optional.of(result);
            }
            return Optional.empty();
        }
        catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException e) {
            throw new OperationFailedApiException(errorMsgMapperFn.apply(e), (Throwable)e);
        }
    }

    public MCClient getMCClient(String cluster) {
        return this.clientManager.clientFor(cluster);
    }

    public HazelcastInstance getHZClient(String cluster) {
        return this.getMCClient(cluster).getHzClient();
    }

    private List<Member> getMembers(MCClient mcClient) {
        HazelcastInstance client = mcClient.getHzClient();
        return new ArrayList<Member>(client.getCluster().getMembers());
    }

    private Member getMember(String memberAddress, HazelcastInstance client) {
        return client.getCluster().getMembers().stream().filter(m -> memberAddress.equals(MemberUtil.getMemberAddress((Member)m))).findFirst().orElseThrow(() -> new NoMemberApiException(memberAddress));
    }
}

