/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HomeDirectoryProviderImpl
implements HomeDirectoryProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeDirectoryProviderImpl.class);
    public static final String DEFAULT_HOME_DIRECTORY_NAME = "hazelcast-mc";
    private final Path homeDirectory;

    public HomeDirectoryProviderImpl(Path homeDirectory) {
        this.homeDirectory = homeDirectory;
        HomeDirectoryProviderImpl.constructDir((Path)homeDirectory);
    }

    public Path get() {
        return this.homeDirectory;
    }

    public long calculateDirectorySize() throws IOException {
        return this.calculateFolderOnDiskSize(this.homeDirectory);
    }

    public long calculateMetricsStorageSize() throws IOException {
        return this.calculateFolderOnDiskSize(this.homeDirectory.resolve("metrics"));
    }

    private long calculateFolderOnDiskSize(Path folder) throws IOException {
        AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        return size.get();
    }

    private static void constructDir(Path homeDirectory) {
        try {
            homeDirectory.toFile().mkdirs();
        }
        catch (SecurityException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        if (!homeDirectory.toFile().canWrite()) {
            throw new IllegalStateException(homeDirectory.toAbsolutePath() + " can not be created. Either make it writable, or set \"" + EnvProperty.HOME_PROP + "\" system property to a writable directory and restart.");
        }
    }
}

