/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.CentralManager;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.StateManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseServiceProvider {
    private final StateManager stateManager;
    private final CentralManager centralManager;
    private final LicenseManager licenseManager;

    public Set<String> getClusterNames(Feature feature) {
        this.licenseManager.checkLicensePerFeature(feature);
        return this.stateManager.getClusterNames();
    }

    public AllState getLatestState(String cluster, Feature feature) {
        this.licenseManager.checkLicensePerFeature(feature);
        AllState latestState = this.stateManager.getLatestState(cluster);
        if (latestState == null) {
            throw new NoClusterApiException(cluster);
        }
        return latestState;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.centralManager.getScheduledExecutorService();
    }

    @ConstructorProperties(value={"stateManager", "centralManager", "licenseManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnterpriseServiceProvider(StateManager stateManager, CentralManager centralManager, LicenseManager licenseManager) {
        this.stateManager = stateManager;
        this.centralManager = centralManager;
        this.licenseManager = licenseManager;
    }
}

