/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.client.MCClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ClusterMemberLimitNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMemberLimitNotifier.class);
    private final MCClientManager mcClientManager;
    private final LicenseManager licenseManager;

    public ClusterMemberLimitNotifier(MCClientManager mcClientManager, LicenseManager licenseManager) {
        this.mcClientManager = mcClientManager;
        this.licenseManager = licenseManager;
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        String cluster = event.getCluster();
        int numberOfMembers = this.getNumberOfMembers(cluster);
        if (this.licenseManager.isAboveMemberLimit(numberOfMembers)) {
            LOGGER.warn("Cluster {} has more than {} members ({}). Receiving metrics for it has been blocked. You need to configure a valid license on Management Center to continue receiving metrics for it.", new Object[]{cluster, 3, numberOfMembers});
        }
    }

    private int getNumberOfMembers(String cluster) {
        MCClient client = this.mcClientManager.clientFor(cluster);
        return client.getHzClient().getCluster().getMembers().size();
    }
}

