/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.ICache;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.management.operation.GetCacheEntryViewEntryProcessor;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.webmonitor.controller.dto.client.ClientWithNearCacheDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientsNearCacheIntervalStatsDTO;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.service.ClientNearCacheStatsManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import lombok.Generated;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CacheManager {
    private static final GetCacheEntryViewEntryProcessor ENTRY_PROCESSOR = new GetCacheEntryViewEntryProcessor();
    private final ClientNearCacheStatsManager clientNearCacheStatsManager;
    private final MCClientManager clientManager;
    private final StateManager stateManager;

    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(String cluster, String cache, long time) {
        return this.clientNearCacheStatsManager.getClientsNearCacheSummaryStats(cluster, cache, InstanceType.CACHE, time);
    }

    public List<ClientWithNearCacheDTO> getClientsWithNearCache(String cluster, String cache) {
        return this.clientNearCacheStatsManager.getClientsByDataStructure(cluster, cache, InstanceType.CACHE);
    }

    public SortedSet<String> getCachesWithClientNearCache(String cluster, String clientUuid) {
        return this.clientNearCacheStatsManager.getDataStructuresByClient(cluster, clientUuid, InstanceType.CACHE);
    }

    public Map<String, String> getCacheEntry(String cluster, String type, String cacheName, String key) {
        this.stateManager.verifyDataAccessEnabled(cluster);
        MCClient mcClient = this.clientManager.clientFor(cluster);
        HazelcastInstance client = mcClient.getHzClient();
        try {
            CacheEntryView cacheEntry;
            ICache cache = client.getCacheManager().getCache(cacheName);
            switch (type) {
                case "string": {
                    cacheEntry = (CacheEntryView)cache.invoke((Object)key, (EntryProcessor)ENTRY_PROCESSOR, new Object[0]);
                    break;
                }
                case "long": {
                    cacheEntry = (CacheEntryView)cache.invoke((Object)Long.valueOf(key), (EntryProcessor)ENTRY_PROCESSOR, new Object[0]);
                    break;
                }
                case "integer": {
                    cacheEntry = (CacheEntryView)cache.invoke((Object)Integer.valueOf(key), (EntryProcessor)ENTRY_PROCESSOR, new Object[0]);
                    break;
                }
                default: {
                    throw new ValidationFailedApiException("Unsupported value type: " + type);
                }
            }
            InternalSerializationService serializationService = mcClient.getSerializationService();
            Object value = cacheEntry == null ? null : serializationService.toObject(cacheEntry.getValue());
            return CacheManager.responseCacheEntry((CacheEntryView)cacheEntry, (Object)value);
        }
        catch (EntryProcessorException e) {
            if (e.getCause() != null && e.getCause() instanceof AccessControlException) {
                throw new OperationFailedApiException("Failed to read cache entry due to insufficient permissions", (Throwable)e);
            }
            throw new OperationFailedApiException("Failed to read cache entry", (Throwable)e);
        }
        catch (Exception e) {
            throw new OperationFailedApiException("Failed to read cache entry", (Throwable)e);
        }
    }

    private static Map<String, String> responseCacheEntry(CacheEntryView<?, ?> entry, Object value) {
        if (entry == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        response.put("cacheBrowse_value", String.valueOf(value));
        response.put("cacheBrowse_class", value != null ? value.getClass().getName() : "null");
        response.put("date_cache_creation_time", Long.toString(entry.getCreationTime()));
        response.put("date_cache_access_time", Long.toString(entry.getExpirationTime()));
        response.put("date_cache_expiration_time", Long.toString(entry.getHits()));
        response.put("cacheBrowse_hits", Long.toString(entry.getLastAccessTime()));
        return response;
    }

    @ConstructorProperties(value={"clientNearCacheStatsManager", "clientManager", "stateManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CacheManager(ClientNearCacheStatsManager clientNearCacheStatsManager, MCClientManager clientManager, StateManager stateManager) {
        this.clientNearCacheStatsManager = clientNearCacheStatsManager;
        this.clientManager = clientManager;
        this.stateManager = stateManager;
    }
}

