/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.security.AuthTokenDTO;
import com.hazelcast.webmonitor.controller.dto.security.IssuedAuthTokenDTO;
import com.hazelcast.webmonitor.model.sql.security.AuthTokenModel;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.utils.CryptoUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AuthTokenManager {
    private static final String LABEL_SUFFIX_PATTERN = "yyyy-MM-dd'T'HH:mm z";
    private final AuthTokenDAO authTokenDAO;

    public IssuedAuthTokenDTO issue(String username) {
        return this.issue(username, null, null);
    }

    public IssuedAuthTokenDTO issue(String username, String label) {
        return this.issue(username, label, null);
    }

    public IssuedAuthTokenDTO issue(String username, String inputLabel, Collection<? extends GrantedAuthority> inputAuthorities) {
        String tokenStr = CryptoUtils.generateRandomToken();
        String tokenHash = CryptoUtils.generateHash((String)tokenStr);
        AuthTokenModel token = new AuthTokenModel();
        token.setTokenHash(tokenHash);
        token.setUsername(username);
        OffsetDateTime issuedAt = OffsetDateTime.now();
        token.setIssuedAt(issuedAt);
        String label = inputLabel != null ? inputLabel : AuthTokenManager.generateDefaultLabel((String)username, (OffsetDateTime)issuedAt);
        token.setLabel(label);
        if (inputAuthorities != null) {
            String roles = inputAuthorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
            token.setRoles(roles);
        }
        this.authTokenDAO.insert(token);
        return IssuedAuthTokenDTO.fromModel((String)tokenStr, (AuthTokenModel)token);
    }

    public boolean validate(String token) {
        return this.find(token).isPresent();
    }

    public Optional<AuthTokenDTO> find(String token) {
        String tokenHash = CryptoUtils.generateHash((String)token);
        return this.authTokenDAO.findByHash(tokenHash).map(AuthTokenDTO::fromModel);
    }

    public List<AuthTokenDTO> findAllForUser(String username) {
        return this.authTokenDAO.findAllForUser(username).stream().map(AuthTokenDTO::fromModel).collect(Collectors.toList());
    }

    public boolean revoke(String token) {
        String tokenHash = CryptoUtils.generateHash((String)token);
        int cnt = this.authTokenDAO.revokeSingleToken(tokenHash);
        return cnt == 1;
    }

    public int revokeAll(String username) {
        return this.authTokenDAO.revokeAllUserTokens(username);
    }

    private static String generateDefaultLabel(String username, OffsetDateTime issuedAt) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm z");
        Timestamp issuedAtDate = Timestamp.valueOf(issuedAt.toLocalDateTime());
        return username + "_" + format.format(issuedAtDate);
    }

    @ConstructorProperties(value={"authTokenDAO"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthTokenManager(AuthTokenDAO authTokenDAO) {
        this.authTokenDAO = authTokenDAO;
    }
}

