/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.saml;

import com.hazelcast.webmonitor.configreplacer.ConfigReplacerHelper;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.PersistentSamlConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlConfig;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SamlConfigMigrator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamlConfigMigrator.class);
    static final String SAML_PROPERTIES_FILE_NAME = "saml.properties";
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final PersistentSamlConfig persistentSamlConfig;
    private final SecurityConfigurationManager configManager;

    @PostConstruct
    public void migrateSamlConfigFromFileToDatabase() {
        Path path = this.homeDirectoryProvider.get().resolve("saml.properties");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!"SAML".equals(this.configManager.getCurrentSecurityProviderName())) {
            log.info("'{}' file was ignored, because current security provider is not SAML.", (Object)"saml.properties");
            SamlConfigMigrator.deleteFile((Path)path);
            return;
        }
        Properties properties = SamlConfigMigrator.readSamlProperties((Path)path);
        if (properties.isEmpty()) {
            log.info("'{}' file was ignored, because it is empty.", (Object)"saml.properties");
            SamlConfigMigrator.deleteFile((Path)path);
            return;
        }
        if (!this.persistentSamlConfig.getProperties().isEmpty()) {
            log.info("'{}' file was ignored, because security provider is already configured in database.", (Object)"saml.properties");
            SamlConfigMigrator.deleteFile((Path)path);
            return;
        }
        SamlConfig config = SamlConfig.fromProperties((Properties)ConfigReplacerHelper.replace((Properties)properties));
        this.persistentSamlConfig.write((SecurityProviderConfig)config);
        log.info("SAML config has been migrated from '{}' file to database", (Object)"saml.properties");
        SamlConfigMigrator.deleteFile((Path)path);
    }

    private static Properties readSamlProperties(Path path) {
        Properties samlProperties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);){
            samlProperties.load(reader);
        }
        catch (IOException e) {
            throw new SecurityConfigApiException("SAML configuration couldn't be read from file [" + path.toAbsolutePath() + "]");
        }
        return samlProperties;
    }

    private static void deleteFile(Path path) {
        try {
            Files.delete(path);
            log.info("'{}' file has been deleted", (Object)path.getFileName());
        }
        catch (IOException e) {
            log.warn("Couldn't delete a '" + path.getFileName() + "' file", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"homeDirectoryProvider", "persistentSamlConfig", "configManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SamlConfigMigrator(HomeDirectoryProvider homeDirectoryProvider, PersistentSamlConfig persistentSamlConfig, SecurityConfigurationManager configManager) {
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.persistentSamlConfig = persistentSamlConfig;
        this.configManager = configManager;
    }
}

