/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.oidc;

import com.google.common.collect.ImmutableList;
import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.oidc.PersistentOidcConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.security.authentication.AuthenticationProvider;

public class OidcSecurityProvider
implements SecurityProvider {
    public static final String OIDC_SECURITY_PROVIDER_NAME = "OpenID Connect";
    private static final List<SecurityConfigParameter> CONFIG_PARAMETERS = ImmutableList.builder().add((Object)SecurityConfigParameter.stringParam((String)"clientID", (String)"Client ID")).add((Object)SecurityConfigParameter.stringParam((String)"clientSecret", (String)"Client Secret")).add((Object)SecurityConfigParameter.stringParam((String)"authorizationEndpoint", (String)"Authorization Endpoint")).add((Object)SecurityConfigParameter.stringParam((String)"userInfoEndpoint", (String)"User Info Endpoint")).add((Object)SecurityConfigParameter.stringParam((String)"tokenEndpoint", (String)"Token Endpoint")).add((Object)SecurityConfigParameter.stringParam((String)"jwkSetEndpoint", (String)"JWK Set Endpoint")).add((Object)SecurityConfigParameter.stringParam((String)"issuer", (String)"Issuer")).add((Object)SecurityConfigParameter.stringParam((String)"scope", (String)"Scope", (String)"openid profile groups")).add((Object)SecurityConfigParameter.stringParam((String)"redirectURL", (String)"Redirect URL")).add((Object)SecurityConfigParameter.stringParam((String)"userIdClaimName", (String)"User ID Claim Name", (String)"preferred_username")).add((Object)SecurityConfigParameter.stringParam((String)"groupsClaimName", (String)"Groups Claim Name", (String)"groups")).add((Object)SecurityConfigParameter.stringParam((String)"jwsAlgorithm", (String)"JWS Algorithm", (String)"RS256")).add((Object)SecurityConfigParameter.stringParam((String)"userInfoRequestHttpMethod", (String)"User Info Request HTTP Method", (String)"GET")).add((Object)SecurityConfigParameter.stringParam((String)"sendClientInfoInTokenRequest", (String)"Send Client Info in Token Request", (String)"false")).addAll((Iterable)GroupsToRolesMappingConfig.CONFIG_PARAMETERS).build();
    final PersistentOidcConfig persistentOidcConfig;

    public String getName() {
        return OIDC_SECURITY_PROVIDER_NAME;
    }

    public List<SecurityConfigParameter> getConfigParameters() {
        return CONFIG_PARAMETERS;
    }

    public void saveConfig(Map<String, String> parameters) {
        this.persistentOidcConfig.write((SecurityProviderConfig)OidcConfig.fromMap(parameters));
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return new NoOpAuthenticationProvider(null);
    }

    @ConstructorProperties(value={"persistentOidcConfig"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcSecurityProvider(PersistentOidcConfig persistentOidcConfig) {
        this.persistentOidcConfig = persistentOidcConfig;
    }
}

