/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.ldap;

import com.google.common.collect.ImmutableList;
import com.hazelcast.webmonitor.config.properties.LdapConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.SSLProperties;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import com.hazelcast.webmonitor.security.spi.impl.PersistentSecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigImportService;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.AbstractLdapSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapUserDetailsContextMapper;
import com.hazelcast.webmonitor.security.spi.impl.ldap.PersistentLdapConfigFactory;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.ssl.SSLContextFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.NestedLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class LdapSecurityProvider
extends AbstractLdapSecurityProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapSecurityProvider.class);
    public static final String LDAP_SECURITY_PROVIDER_NAME = "LDAP";
    private static final List<SecurityConfigParameter> CONFIG_PARAMETERS = ImmutableList.builder().add((Object)SecurityConfigParameter.stringParam((String)"url", (String)"URL", (String)"ldap://localhost:10389")).add((Object)SecurityConfigParameter.stringParam((String)"username", (String)"Distinguished name (DN) of user", (String)"cn=Some User,cn=users,dc=example,dc=com")).add((Object)SecurityConfigParameter.secretParam((String)"password", (String)"Password")).add((Object)SecurityConfigParameter.stringParam((String)"userDn", (String)"User DN", (String)"ou=users,o=yourorg")).add((Object)SecurityConfigParameter.stringParam((String)"groupDn", (String)"Group DN", (String)"ou=groups,o=yourorg")).add((Object)SecurityConfigParameter.boolParam((String)"startTls", (String)"Start TLS")).add((Object)SecurityConfigParameter.stringParam((String)"userSearchFilter", (String)"User Search Filter", (String)"uid={0}")).add((Object)SecurityConfigParameter.stringParam((String)"groupSearchFilter", (String)"Group Search Filter", (String)"uniquemember={0}")).add((Object)SecurityConfigParameter.boolParam((String)"nestedGroupSearch", (String)"Nested Group Search", (boolean)true)).addAll((Iterable)GroupsToRolesMappingConfig.CONFIG_PARAMETERS).build();
    private LdapAuthenticationProvider authenticationProvider;
    private final PersistentSecurityProviderConfig<LdapConfig> persistentLdapConfig;
    private final SecurityConfigImportService securityConfigImportService;
    private final LdapConfigurationProperties ldapProperties;

    public LdapSecurityProvider(HomeDirectoryProvider homeDirectoryProvider, Jdbi jdbi, GroupedSettingsDAO groupedSettingsDAO, SecurityConfigImportService securityConfigImportService, MCConfigurationProperties mcProperties, LdapConfigurationProperties ldapProperties) {
        this.persistentLdapConfig = new PersistentLdapConfigFactory(homeDirectoryProvider, jdbi, groupedSettingsDAO, mcProperties).create();
        this.securityConfigImportService = securityConfigImportService;
        this.ldapProperties = ldapProperties;
    }

    public String getName() {
        return LDAP_SECURITY_PROVIDER_NAME;
    }

    public List<SecurityConfigParameter> getConfigParameters() {
        return CONFIG_PARAMETERS;
    }

    public void saveConfig(Map<String, String> parameters) {
        LdapConfig ldapConfig = LdapConfig.fromMap(parameters);
        this.persistentLdapConfig.write((SecurityProviderConfig)ldapConfig);
        this.initAuthenticationProvider(ldapConfig);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        if (this.authenticationProvider == null) {
            this.initAuthenticationProvider((LdapConfig)this.persistentLdapConfig.get());
        }
        return this.authenticationProvider;
    }

    public void reloadConfig() {
        LdapConfig ldapConfig = LdapConfig.fromProperties((Properties)this.securityConfigImportService.readProperties());
        this.persistentLdapConfig.write((SecurityProviderConfig)ldapConfig);
        this.initAuthenticationProvider((LdapConfig)this.persistentLdapConfig.get());
        this.securityConfigImportService.cleanupOnSuccessfulImport();
    }

    public boolean reloadConfigAvailable() {
        return this.securityConfigImportService.importPropertiesAvailable();
    }

    private void initAuthenticationProvider(LdapConfig ldapConfig) {
        this.checkLdapCredentials(ldapConfig);
        LdapContextSource ldapContextSource = this.createLdapContextSource(ldapConfig);
        String groupDn = StringUtils.defaultString((String)ldapConfig.getGroupDn());
        NestedLdapAuthoritiesPopulator authPopulator = ldapConfig.isNestedGroupSearch() ? new NestedLdapAuthoritiesPopulator((ContextSource)ldapContextSource, groupDn) : new DefaultLdapAuthoritiesPopulator((ContextSource)ldapContextSource, groupDn);
        authPopulator.setRolePrefix("");
        authPopulator.setGroupSearchFilter(ldapConfig.getGroupSearchFilter());
        authPopulator.setSearchSubtree(true);
        BindAuthenticator ldapAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(ldapConfig.getUserDn(), ldapConfig.getUserSearchFilter(), (BaseLdapPathContextSource)ldapContextSource);
        userSearch.setSearchSubtree(true);
        ldapAuthenticator.setUserSearch((LdapUserSearch)userSearch);
        LdapAuthenticationProvider authProvider = new LdapAuthenticationProvider((LdapAuthenticator)ldapAuthenticator, (LdapAuthoritiesPopulator)authPopulator);
        authProvider.setUserDetailsContextMapper((UserDetailsContextMapper)new LdapUserDetailsContextMapper(ldapConfig.getGroupsToRolesMappingConfig()));
        this.authenticationProvider = authProvider;
    }

    private LdapContextSource createLdapContextSource(LdapConfig ldapConfig) {
        LdapContextSource ldapContextSource = new LdapContextSource();
        ldapContextSource.setUrl(ldapConfig.getUrl());
        ldapContextSource.setUserDn(ldapConfig.getUsername());
        ldapContextSource.setPassword(ldapConfig.getPassword());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.ldapProperties.getTimeout()));
        env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.ldapProperties.getTimeout()));
        ldapContextSource.setBaseEnvironmentProperties(env);
        if (ldapConfig.isStartTls()) {
            LOGGER.info("Using Start TLS for LDAP authentication.");
            DefaultTlsDirContextAuthenticationStrategy strategy = new DefaultTlsDirContextAuthenticationStrategy();
            try {
                strategy.setSslSocketFactory(SSLContextFactory.createSSLContext((SSLProperties)this.ldapProperties.getSsl()).getSocketFactory());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to enable Start TLS.", (Throwable)e);
            }
            ldapContextSource.setAuthenticationStrategy((DirContextAuthenticationStrategy)strategy);
        }
        if (this.isSslConnection(ldapConfig.getUrl())) {
            LOGGER.info("Using LDAP over SSL for LDAP authentication.");
            try {
                SSLContext.setDefault(SSLContextFactory.createSSLContext((SSLProperties)this.ldapProperties.getSsl()));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to enable ldaps.", (Throwable)e);
            }
        }
        ldapContextSource.afterPropertiesSet();
        return ldapContextSource;
    }

    private void checkLdapCredentials(LdapConfig ldapConfig) {
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)this.createLdapContextSource(ldapConfig));
        DirContext context = null;
        try {
            context = ldapTemplate.getContextSource().getContext(ldapConfig.getUsername(), ldapConfig.getPassword());
        }
        catch (NamingException e) {
            try {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                throw new SecurityConfigApiException(e.getExplanation());
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(context);
                throw throwable;
            }
        }
        LdapUtils.closeContext((Context)context);
    }
}

