/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl;

import com.google.common.collect.ImmutableMap;
import com.hazelcast.webmonitor.controller.exception.InvalidOperationApiException;
import com.hazelcast.webmonitor.controller.exception.NoUserFoundApiException;
import com.hazelcast.webmonitor.model.sql.UserCredentialsModel;
import com.hazelcast.webmonitor.security.UserHasNoRolesException;
import com.hazelcast.webmonitor.security.spi.ReloadableSecurityProvider;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.UserManagementProvider;
import com.hazelcast.webmonitor.security.spi.impl.DisableLoginStrategy;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class AuthenticationManagerImpl
implements AuthenticationManager,
AutoCloseable {
    private final Map<String, SecurityProvider> providerPool = new HashMap();
    private final SecurityConfigurationManager securityConfigurationManager;
    private final DisableLoginStrategy disableLoginStrategy;
    private final List<String> securityProviderList;

    AuthenticationManagerImpl(SecurityConfigurationManager configManager, DisableLoginStrategy disableLoginStrategy, List<SecurityProvider> providers) {
        this.securityConfigurationManager = configManager;
        this.disableLoginStrategy = disableLoginStrategy;
        providers.forEach(provider -> this.providerPool.put(provider.getName(), provider));
        this.securityProviderList = providers.stream().map(SecurityProvider::getName).collect(Collectors.toList());
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        if (StringUtil.isNullOrEmptyAfterTrim((String)username)) {
            throw new BadCredentialsException("No username provided!");
        }
        this.disableLoginStrategy.checkIfDisabled(username);
        try {
            Authentication result = this.getAuthenticationProvider().authenticate(authentication);
            if (result.isAuthenticated()) {
                if (result.getAuthorities().isEmpty()) {
                    throw new UserHasNoRolesException();
                }
                this.disableLoginStrategy.successfulLogin(username);
            }
            return result;
        }
        catch (AuthenticationException e) {
            this.disableLoginStrategy.failedLoginAttempt(username);
            throw e;
        }
    }

    @Override
    public void close() {
        this.disableLoginStrategy.close();
    }

    public boolean checkPassword(String username, String password) {
        try {
            this.getAuthenticationProvider().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    public List<String> getSecurityProviders() {
        return this.securityProviderList;
    }

    public void saveSecurityProviderConfig(Map<String, String[]> parameterMap) {
        if (this.isSecurityProviderConfigured()) {
            throw this.securityAlreadyConfiguredException();
        }
        this.updateSecurityProviderConfig(parameterMap);
    }

    public void updateSecurityProviderConfig(Map<String, String[]> parameterMap) {
        String provider = parameterMap.get("providerHiddenInput")[0];
        SecurityProvider currentProvider = this.getCurrentSecurityProvider();
        if (currentProvider != null && !"Dev Mode".equals(currentProvider.getName())) {
            throw this.securityAlreadyConfiguredException();
        }
        SecurityProvider securityProvider = (SecurityProvider)this.providerPool.get(provider);
        if (securityProvider == null) {
            throw new SecurityConfigApiException("Unknown security provider " + provider + ".");
        }
        Map parameters = this.extractParameters(securityProvider, parameterMap);
        securityProvider.saveConfig(parameters);
        this.securityConfigurationManager.setCurrentSecurityProviderName(provider);
    }

    public SecurityConfigApiException securityAlreadyConfiguredException() {
        return new SecurityConfigApiException("Security is already configured!");
    }

    public void activateDevMode() {
        this.saveSecurityProviderConfig((Map)ImmutableMap.of((Object)"providerHiddenInput", (Object)new String[]{"Dev Mode"}));
    }

    public Optional<String> testSecurityProviderConfig(String testUsername, String testPassword, Map<String, String[]> parameterMap) {
        if (!parameterMap.containsKey("providerHiddenInput") || parameterMap.get("providerHiddenInput").length == 0 || StringUtil.isNullOrEmptyAfterTrim((String)parameterMap.get("providerHiddenInput")[0])) {
            throw new SecurityConfigApiException("Provider needs to be specified for testing security provider config.");
        }
        String provider = parameterMap.get("providerHiddenInput")[0];
        SecurityProvider securityProvider = (SecurityProvider)this.providerPool.get(provider);
        if (securityProvider == null) {
            throw new SecurityConfigApiException(String.format("No security provider found with name %s.", provider));
        }
        Map parameters = this.extractParameters(securityProvider, parameterMap);
        return securityProvider.testConfig(testUsername, testPassword, parameters);
    }

    private Map<String, String> extractParameters(SecurityProvider securityProvider, Map<String, String[]> parameterMap) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (SecurityConfigParameter configParameter : securityProvider.getConfigParameters()) {
            String[] stringArr = parameterMap.get(configParameter.getName() + "Input");
            if (stringArr == null || stringArr.length <= 0) continue;
            parameters.put(configParameter.getName(), stringArr[0]);
        }
        return parameters;
    }

    public boolean isSecurityProviderConfigured() {
        return !StringUtil.isNullOrEmptyAfterTrim((String)this.securityConfigurationManager.getCurrentSecurityProviderName());
    }

    public boolean isReloadSecurityConfigSupported() {
        return this.isSecurityProviderConfigured() && this.getCurrentSecurityProvider() instanceof ReloadableSecurityProvider;
    }

    public boolean isReloadSecurityConfigAvailable() {
        return this.isReloadSecurityConfigSupported() && ((ReloadableSecurityProvider)this.getCurrentSecurityProvider()).reloadConfigAvailable();
    }

    public void reloadSecurityConfig() {
        this.checkSecurityProviderConfigured();
        if (!this.isReloadSecurityConfigSupported()) {
            throw new UnsupportedOperationException("Reloading configuration is not supported for " + this.securityConfigurationManager.getCurrentSecurityProviderName());
        }
        ((ReloadableSecurityProvider)this.getCurrentSecurityProvider()).reloadConfig();
    }

    public boolean isUserManagementSupported() {
        return this.isSecurityProviderConfigured() && this.getCurrentSecurityProvider() instanceof UserManagementProvider;
    }

    public List<UserCredentialsModel> getUsers() {
        this.checkSecurityProviderConfigured();
        this.checkUserManagementSupported();
        return this.getCurrentUserManagementProvider().getUsers();
    }

    public UserCredentialsModel getUser(String username) {
        this.checkSecurityProviderConfigured();
        this.checkUserManagementSupported();
        return (UserCredentialsModel)this.getCurrentUserManagementProvider().getUser(username).orElseThrow(() -> new NoUserFoundApiException(username));
    }

    public void deleteUser(String username) {
        this.checkSecurityProviderConfigured();
        this.checkUserManagementSupported();
        this.getCurrentUserManagementProvider().deleteUser(username);
    }

    public void changePassword(String username, String password) {
        this.checkSecurityProviderConfigured();
        this.checkUserManagementSupported();
        this.getCurrentUserManagementProvider().changePassword(username, password);
    }

    public void updateUser(String username, String role) {
        this.checkSecurityProviderConfigured();
        this.checkUserManagementSupported();
        this.getCurrentUserManagementProvider().updateUser(username, role);
    }

    public void createUser(String username, String password, String role) {
        this.checkSecurityProviderConfigured();
        this.checkUserManagementSupported();
        this.getCurrentUserManagementProvider().createUser(username, password, role);
    }

    public String getCurrentSecurityProviderName() {
        return Optional.ofNullable(this.getCurrentSecurityProvider()).map(SecurityProvider::getName).orElse(null);
    }

    public SecurityProvider getCurrentSecurityProvider() {
        return (SecurityProvider)this.providerPool.get(this.securityConfigurationManager.getCurrentSecurityProviderName());
    }

    private AuthenticationProvider getAuthenticationProvider() {
        this.checkSecurityProviderConfigured();
        return this.getCurrentSecurityProvider().getAuthenticationProvider();
    }

    private void checkSecurityProviderConfigured() {
        if (!this.isSecurityProviderConfigured()) {
            throw new InvalidOperationApiException("Security provider needs to be configured first!");
        }
    }

    private void checkUserManagementSupported() {
        if (!this.isUserManagementSupported()) {
            throw new InvalidOperationApiException("User management not supported by " + this.securityConfigurationManager.getCurrentSecurityProviderName() + " security provider");
        }
    }

    private UserManagementProvider getCurrentUserManagementProvider() {
        return (UserManagementProvider)this.getCurrentSecurityProvider();
    }

    public boolean isDevModeActive() {
        return this.getCurrentSecurityProvider() == this.providerPool.get("Dev Mode");
    }
}

