/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi;

import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public interface SecurityProvider {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_READONLY_USER = "ROLE_READONLY_USER";
    public static final String ROLE_METRICS_ONLY = "ROLE_METRICS_ONLY";
    public static final String ROLE_CLOUD_USER = "ROLE_CLOUD_USER";
    public static final GrantedAuthority ADMIN_AUTHORITY = new SimpleGrantedAuthority("ROLE_ADMIN");
    public static final GrantedAuthority USER_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");
    public static final GrantedAuthority READONLY_USER_AUTHORITY = new SimpleGrantedAuthority("ROLE_READONLY_USER");
    public static final GrantedAuthority METRICS_ONLY_AUTHORITY = new SimpleGrantedAuthority("ROLE_METRICS_ONLY");

    public String getName();

    public List<SecurityConfigParameter> getConfigParameters();

    public void saveConfig(Map<String, String> var1);

    public AuthenticationProvider getAuthenticationProvider();

    default public Optional<String> testConfig(String testUsername, String testPassword, Map<String, String> parameters) {
        throw new UnsupportedOperationException("Testing security config is not supported for this provider: " + this.getName());
    }
}

