/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.UserCredentialsModel;
import com.hazelcast.webmonitor.utils.CryptoUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Service;

@Service
public class UserCredentialsDAO {
    private final Jdbi jdbi;

    public void insert(UserCredentialsModel user) {
        this.jdbi.useHandle(handle -> this.insertTx(handle, user));
    }

    public void insertTx(Handle handle, UserCredentialsModel user) {
        String hashedPass = CryptoUtils.generatePasswordHash((String)user.getUsername(), (String)user.getPassword());
        ((Update)((Update)((Update)handle.createUpdate("insert into user_credentials (username, password, role) values (:username, :password, :role)").bind("username", user.getUsername())).bind("password", hashedPass)).bind("role", user.getRole())).execute();
    }

    public void update(UserCredentialsModel user) {
        this.jdbi.withHandle(handle -> ((Update)((Update)((Update)handle.createUpdate("update user_credentials set password = :password, role = :role where username = :username").bind("username", user.getUsername())).bind("password", user.getPassword())).bind("role", user.getRole())).execute());
    }

    public List<UserCredentialsModel> getUsers() {
        return (List)this.jdbi.withHandle(handle -> handle.createQuery("select username, role from user_credentials order by username").mapToBean(UserCredentialsModel.class).list());
    }

    public List<String> getUsernamesTx(Handle handle) {
        return handle.createQuery("select username from user_credentials order by username").mapTo(String.class).list();
    }

    public void delete(String username) {
        this.jdbi.withHandle(handle -> this.deleteTx(handle, username));
    }

    public int deleteTx(Handle handle, String username) {
        return ((Update)handle.createUpdate("delete from user_credentials where username = :username").bind("username", username)).execute();
    }

    public Optional<UserCredentialsModel> login(String username, String providedPassword) {
        Optional user = this.findByUsername(username);
        String providedPasswordHash = CryptoUtils.generatePasswordHash((String)username, (String)providedPassword);
        return user.filter(userWithPassword -> userWithPassword.getPassword().equals(providedPasswordHash));
    }

    public Optional<UserCredentialsModel> findByUsername(String username) {
        return (Optional)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select username, password, role from user_credentials where username = :username").bind("username", username)).mapToBean(UserCredentialsModel.class).findFirst());
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UserCredentialsDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

