/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.SettingModel;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Service;

@Service
public class SettingsDAO {
    private final Jdbi jdbi;

    public SettingsDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public List<SettingModel> findAll() {
        return (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT name, value FROM settings").mapToBean(SettingModel.class).list());
    }

    public Optional<SettingModel> findByName(String name) {
        return (Optional)this.jdbi.withHandle(handle -> this.findByNameTx(handle, name));
    }

    private Optional<SettingModel> findByNameTx(Handle handle, String name) {
        return ((Query)handle.createQuery("SELECT name, value FROM settings WHERE name = :name").bind("name", name)).mapToBean(SettingModel.class).findFirst();
    }

    List<SettingModel> findByPrefix(String prefix) {
        String escaped = this.escapeLikeOperatorWildcards(prefix);
        return (List)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("SELECT name, value FROM settings WHERE name LIKE :prefix").bind("prefix", escaped + "%")).mapToBean(SettingModel.class).list());
    }

    public void insertOrUpdate(SettingModel setting) {
        this.jdbi.useHandle(handle -> this.insertOrUpdateTx(handle, setting));
    }

    public void insertOrUpdateTx(Handle handle, SettingModel setting) {
        Optional existingSetting = this.findByNameTx(handle, setting.getName());
        if (existingSetting.isPresent()) {
            this.updateTx(handle, setting);
        } else {
            this.insertTx(handle, setting);
        }
    }

    private void insertTx(Handle handle, SettingModel setting) {
        ((Update)((Update)handle.createUpdate("INSERT INTO settings (name, value) VALUES (:name, :value)").bind("name", setting.getName())).bind("value", setting.getValue())).execute();
    }

    private void updateTx(Handle handle, SettingModel setting) {
        ((Update)((Update)handle.createUpdate("UPDATE settings SET value = :value WHERE name = :name").bind("value", setting.getValue())).bind("name", setting.getName())).execute();
    }

    public void deleteByName(String name) {
        this.jdbi.useHandle(handle -> this.deleteByNameTx(handle, name));
    }

    public void deleteByNameTx(Handle handle, String name) {
        ((Update)handle.createUpdate("DELETE FROM settings WHERE name = :name").bind("name", name)).execute();
    }

    void deleteByPrefix(String prefix) {
        this.jdbi.useHandle(handle -> this.deleteByPrefixTx(handle, prefix));
    }

    void deleteByPrefixTx(Handle handle, String prefix) {
        String escapedPrefix = this.escapeLikeOperatorWildcards(prefix);
        ((Update)handle.createUpdate("DELETE FROM settings WHERE name LIKE :prefix").bind("prefix", escapedPrefix + "%")).execute();
    }

    private String escapeLikeOperatorWildcards(String prefix) {
        return prefix.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
    }
}

