/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.ScriptModel;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Service;

@Service
public class ScriptDAO {
    private final Jdbi jdbi;

    public ScriptDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public List<String> findNamesByUsername(String username) {
        return (List)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("SELECT script_name FROM scripts WHERE username = :username ORDER BY script_name").bind("username", username)).mapTo(String.class).list());
    }

    public void insertOrUpdate(ScriptModel script) {
        this.jdbi.useTransaction(handle -> {
            Optional existingScript = this.findByUsernameAndNameTx(handle, script.getUsername(), script.getScriptName());
            if (existingScript.isPresent()) {
                this.updateTx(handle, script);
            } else {
                this.insertTx(handle, script);
            }
        });
    }

    public Optional<ScriptModel> findByUsernameAndName(String username, String name) {
        return (Optional)this.jdbi.withHandle(handle -> this.findByUsernameAndNameTx(handle, username, name));
    }

    private Optional<ScriptModel> findByUsernameAndNameTx(Handle handle, String username, String name) {
        return ((Query)((Query)handle.createQuery("SELECT username, script_name, language, code FROM scripts WHERE username = :username AND script_name = :scriptName").bind("username", username)).bind("scriptName", name)).mapToBean(ScriptModel.class).findFirst();
    }

    private void updateTx(Handle handle, ScriptModel script) {
        ((Update)((Update)((Update)((Update)handle.createUpdate("UPDATE scripts SET language = :language, code = :code WHERE username = :username AND script_name = :scriptName").bind("language", script.getLanguage())).bind("code", script.getCode())).bind("username", script.getUsername())).bind("scriptName", script.getScriptName())).execute();
    }

    private void insertTx(Handle handle, ScriptModel script) {
        ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO scripts (username, script_name, language, code) VALUES (:username, :scriptName, :language, :code)").bind("username", script.getUsername())).bind("scriptName", script.getScriptName())).bind("language", script.getLanguage())).bind("code", script.getCode())).execute();
    }

    public void deleteByUsernameTx(Handle handle, String username) {
        ((Update)handle.createUpdate("DELETE FROM scripts WHERE username = :username").bind("username", username)).execute();
    }

    public void delete(String username, String name) {
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("DELETE FROM scripts WHERE username = :username AND script_name = :scriptName").bind("username", username)).bind("scriptName", name)).execute());
    }
}

