/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.impl.InternalStorageException;
import com.hazelcast.webmonitor.metrics.impl.MetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBLoader;
import com.hazelcast.webmonitor.metrics.impl.serde.IntegerSerde;
import com.hazelcast.webmonitor.metrics.impl.serde.RegistryKeySerde;
import com.hazelcast.webmonitor.metrics.impl.serde.RegistryValueSerde;
import java.nio.file.Path;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RocksDBMetricsRegistry
implements MetricsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBMetricsRegistry.class);
    static final String STORE_SUBDIR = "registry";
    private final RegistryKeySerde keySerde = new RegistryKeySerde();
    private final RegistryValueSerde valueSerde = new RegistryValueSerde();
    private final IntegerSerde integerSerde = new IntegerSerde();
    private final Path path;
    private final RocksDB store;
    private final Cache<MetricsRegistry.RegistryKey, MetricsRegistry.RegistryValue> cache;
    private final byte[] sequenceKeyBinary;
    private final ReadWriteLock closeInProgressLock = new ReentrantReadWriteLock();
    private boolean closed;

    public RocksDBMetricsRegistry(Path dir, int maxSize) throws InternalStorageException.InternalLoadNativeException, InternalStorageException.InternalOpenOrCreateStoreException {
        RocksDBLoader.loadLibrary();
        this.path = dir.resolve("registry");
        this.store = RocksDBMetricsRegistry.openOrCreateStore((Path)this.path);
        this.sequenceKeyBinary = this.keySerde.serialize((Object)MetricsRegistry.RegistryKey.nil());
        this.cache = Caffeine.newBuilder().maximumSize((long)maxSize).build();
    }

    public MetricsRegistry.RegistryValue get(MetricsRegistry.RegistryKey key) throws InternalStorageException.InternalClosedStoreException, InternalStorageException.InternalPersistenceException {
        if (key.isNil()) {
            throw new IllegalArgumentException("Registry key must not be nil");
        }
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            MetricsRegistry.RegistryValue registryValue = this.readMetadata(key);
            return registryValue;
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private MetricsRegistry.RegistryValue readMetadata(MetricsRegistry.RegistryKey key) throws InternalStorageException.InternalClosedStoreException, InternalStorageException.InternalPersistenceException {
        try {
            MetricsRegistry.RegistryValue value = (MetricsRegistry.RegistryValue)this.cache.getIfPresent((Object)key);
            if (value != null) {
                return value;
            }
            value = this.readMetadataFromStorage(key);
            if (value != null) {
                this.cache.put((Object)key, (Object)value);
            }
            return value;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof InternalStorageException.InternalClosedStoreException) {
                throw (InternalStorageException.InternalClosedStoreException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new InternalStorageException.InternalPersistenceException(e.getCause());
            }
            throw new InternalStorageException.InternalPersistenceException((Throwable)e);
        }
    }

    private MetricsRegistry.RegistryValue readMetadataFromStorage(MetricsRegistry.RegistryKey key) throws RocksDBException {
        byte[] keyBinary = this.keySerde.serialize((Object)key);
        byte[] valueBinary = this.store.get(keyBinary);
        if (valueBinary != null) {
            return (MetricsRegistry.RegistryValue)this.valueSerde.deserialize(valueBinary);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsRegistry.RegistryValue register(MetricsRegistry.RegistryKey key, DataPointType type) throws InternalStorageException.InternalClosedStoreException, InternalStorageException.InternalPersistenceException {
        this.closeInProgressLock.readLock().lock();
        try {
            MetricsRegistry.RegistryValue registryValue;
            this.ensureOpen();
            MetricsRegistry.RegistryValue existingRegistryValue = this.readMetadata(key);
            if (existingRegistryValue != null) {
                MetricsRegistry.RegistryValue registryValue2 = existingRegistryValue;
                return registryValue2;
            }
            byte[] keyBinary = this.keySerde.serialize((Object)key);
            RocksDBMetricsRegistry rocksDBMetricsRegistry = this;
            synchronized (rocksDBMetricsRegistry) {
                block12: {
                    MetricsRegistry.RegistryValue persistedRegistryValue = this.readMetadataFromStorage(key);
                    if (persistedRegistryValue == null) break block12;
                    MetricsRegistry.RegistryValue registryValue3 = persistedRegistryValue;
                    return registryValue3;
                }
                int nextId = this.nextId();
                byte[] idBinary = this.integerSerde.serialize((Object)nextId);
                this.store.put(this.sequenceKeyBinary, idBinary);
                registryValue = new MetricsRegistry.RegistryValue(nextId, type);
                byte[] valueBinary = this.valueSerde.serialize((Object)registryValue);
                this.store.put(keyBinary, valueBinary);
            }
            this.cache.put((Object)key, (Object)registryValue);
            rocksDBMetricsRegistry = registryValue;
            return rocksDBMetricsRegistry;
        }
        catch (RocksDBException e) {
            throw new InternalStorageException.InternalPersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private int nextId() throws RocksDBException {
        byte[] value = this.store.get(this.sequenceKeyBinary);
        if (value == null) {
            return 0;
        }
        return (Integer)this.integerSerde.deserialize(value) + 1;
    }

    public void close() {
        this.closeInProgressLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.store.closeE();
        }
        catch (Exception e) {
            LOGGER.warn("Could not close metrics registry store {}.", (Object)this.path, (Object)e);
        }
        finally {
            this.closeInProgressLock.writeLock().unlock();
        }
    }

    public int size() {
        this.closeInProgressLock.readLock().lock();
        try {
            if (this.closed) {
                int n = -1;
                return n;
            }
            int n = this.nextId();
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private void ensureOpen() throws InternalStorageException.InternalClosedStoreException {
        if (this.closed) {
            throw new InternalStorageException.InternalClosedStoreException("Store is already closed.");
        }
    }

    private static RocksDB openOrCreateStore(Path path) throws InternalStorageException.InternalOpenOrCreateStoreException {
        RocksDB rocksDB;
        block8: {
            Options options = new Options().setCreateIfMissing(true).setMaxLogFileSize(0x500000L).setKeepLogFileNum(10L);
            try {
                rocksDB = RocksDB.open((Options)options, (String)path.toAbsolutePath().toString());
                if (options == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (options != null) {
                        try {
                            options.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new InternalStorageException.InternalOpenOrCreateStoreException(path, (Throwable)e);
                }
            }
            options.close();
        }
        return rocksDB;
    }
}

