/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.controller.dto.TablePresetDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.service.TablePresetService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(path={"/api"})
public class TablePresetController {
    private final TablePresetService tablePresetService;

    @GetMapping(value={"/tablePreset/{tableId}"})
    public List<TablePresetDTO> getTablePresets(@PathVariable String tableId) {
        return this.tablePresetService.getPresetsOfTable(tableId);
    }

    @PostMapping(value={"/tablePreset/{tableId}"})
    public void setTablePresets(@PathVariable String tableId, @Valid @RequestBody List<TablePresetDTO> presets, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.tablePresetService.setPresetsOfTable(tableId, presets);
    }

    @ConstructorProperties(value={"tablePresetService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TablePresetController(TablePresetService tablePresetService) {
        this.tablePresetService = tablePresetService;
    }
}

