/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.security.CustomAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticator;
import com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class OidcController {
    public static final String AUTH_CODE_ENDPOINT = "/oidc/auth";
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcController.class);
    private final OidcAuthenticator authenticator;
    private final CustomAuthenticationFailureHandler authFailureHandler;

    public OidcController(OidcAuthenticator authenticator, CustomAuthenticationFailureHandler authFailureHandler) {
        this.authenticator = authenticator;
        this.authFailureHandler = authFailureHandler;
    }

    @PostMapping(value={"/oidc/sso"}, produces={"text/html; charset=utf-8"})
    public void sso(HttpServletResponse response, HttpSession session) throws IOException {
        String url = this.authenticator.generateAuthenticationRequestURL(session);
        LOGGER.debug("Redirecting user to authentication request URL {}.", (Object)url);
        response.sendRedirect(url);
    }

    @GetMapping(value={"/oidc/auth"}, produces={"text/html; charset=utf-8"})
    public void handleAuthCode(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ParseException, URISyntaxException, IOException {
        URI requestURI = new URI(request.getRequestURL().toString() + "?" + request.getQueryString());
        try {
            String username = this.authenticator.completeAuthentication(session, requestURI);
            LOGGER.debug("Authenticated user {} via OpenID Connect.", (Object)username);
            response.sendRedirect(request.getContextPath() + "/");
        }
        catch (AuthenticationException e) {
            this.authFailureHandler.onAuthenticationFailure(request, response, e);
        }
    }
}

