/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.controller.dto.metrics.BaseDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.DataPointsInRangeQueryDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.LatestDataPointQueryDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.metrics.MetricsQueryService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class MetricsQueryController {
    public static final long MAX_TIME_RANGE_MS = 3600000L;
    public static final long LATEST_LOOKUP_INTERVAL_MS = 60000L;
    private final MetricsQueryService metricsQueryService;
    private final Clock clock;
    private final MetricsConfigurationProperties metricsProperties;

    @PostMapping(path={"/clusters/{cluster}/metrics/query-range"})
    public List<List<BaseDataPointDTO>> queryDataPointsInRange(@PathVariable(value="cluster") String cluster, @Valid @RequestBody DataPointsInRangeQueryDTO queryDTO, BindingResult bindingResult) {
        if (!this.validateRange(queryDTO)) {
            throw new ValidationFailedApiException("Invalid or too big time range specified for query.");
        }
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        return this.metricsQueryService.queryRange(cluster, queryDTO.getMetrics(), queryDTO.getStartTime(), queryDTO.getEndTime());
    }

    private boolean validateRange(DataPointsInRangeQueryDTO dto) {
        Duration duration = this.metricsProperties.getDiskTtl();
        long intervalDuration = dto.getEndTime() - dto.getStartTime();
        if (intervalDuration > duration.getSeconds() * 1000L) {
            return false;
        }
        return dto.getStartTime() <= dto.getEndTime();
    }

    @PostMapping(path={"/clusters/{cluster}/metrics/query-latest"})
    public List<BaseDataPointDTO> queryLatestDataPoint(@PathVariable(value="cluster") String cluster, @Valid @RequestBody LatestDataPointQueryDTO queryDTO, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        long endTime = queryDTO.getTime() == 0L ? this.clock.currentTimeMillis() : queryDTO.getTime();
        long interval = queryDTO.getInterval() == 0L ? 60000L : queryDTO.getInterval();
        long startTime = endTime - interval;
        return this.metricsQueryService.queryLatest(cluster, queryDTO.getMetrics(), startTime, endTime);
    }

    @ConstructorProperties(value={"metricsQueryService", "clock", "metricsProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsQueryController(MetricsQueryService metricsQueryService, Clock clock, MetricsConfigurationProperties metricsProperties) {
        this.metricsQueryService = metricsQueryService;
        this.clock = clock;
        this.metricsProperties = metricsProperties;
    }
}

