/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.dynamicconfig.ConfigUpdateEventDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.controller.internal.DynamicConfigController;
import com.hazelcast.webmonitor.events.ConfigUpdateEventStore;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.dynamicconfig.ConfigPatch;
import com.hazelcast.webmonitor.service.dynamicconfig.ConfigurationUpdateService;
import java.util.List;
import java.util.UUID;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DynamicConfigController
extends BaseInternalController {
    private final ConfigurationUpdateService configUpdate;
    private final ConfigUpdateEventStore eventStore;

    public DynamicConfigController(StateManager stateManager, AuditLogService auditService, ConfigurationUpdateService configUpdate, ConfigUpdateEventStore eventStore) {
        super(stateManager, auditService);
        this.configUpdate = configUpdate;
        this.eventStore = eventStore;
    }

    @PostMapping(value={"/clusters/{cluster}/configurationUpdate"})
    public UpdateResponseDTO update(@PathVariable String cluster, @RequestBody UpdateRequestDTO request) {
        UUID configUpdateProcessId = this.configUpdate.startUpdateProcess(cluster, ConfigPatch.ofText((String)request.getConfigPatch()));
        return new UpdateResponseDTO(configUpdateProcessId.toString());
    }

    @PostMapping(value={"/clusters/{cluster}/configurationUpdate/preview"})
    public ConfigUpdateResult preview(@PathVariable String cluster, @RequestBody UpdateRequestDTO request) {
        return this.configUpdate.preview(cluster, ConfigPatch.ofText((String)request.getConfigPatch()));
    }

    @GetMapping(value={"/configurationUpdate/{configUpdateProcessId}/events"})
    public List<ConfigUpdateEventDTO> pollEvents(@PathVariable(value="configUpdateProcessId") String configUpdateProcessId) {
        List events = this.eventStore.findEventsByUpdateProcessId(UUID.fromString(configUpdateProcessId));
        return new EventListDTOMapper().mapToDTOs(events);
    }
}

