/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.external;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.controller.dto.clustered.CacheStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClusterHealthDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClusterStateDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ConnectionManagerStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.EventServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ExecutorStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.FlakeIdGeneratorStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ManagedExecutorStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MemberStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MultiMapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.OperationServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.PNCounterStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.PartitionServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ProxyServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.QueueStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ReplicatedMapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.TopicStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.WanRepStatsDTO;
import com.hazelcast.webmonitor.controller.exception.NoClientApiException;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoDataStructureApiException;
import com.hazelcast.webmonitor.controller.exception.NoMemberApiException;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.HzExecutorNames;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.service.ClusterHealthCheckService;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.EnterpriseServiceProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.Licensed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest"})
@Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
@ConditionalOnProperty(name={"hazelcast.mc.rest.enabled"}, havingValue="true")
public class ClusteredRestController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusteredRestController.class);
    private static final Feature FEATURE = Feature.CLUSTERED_REST;
    private final EnterpriseServiceProvider enterpriseServiceProvider;
    private final LicenseManager licenseManager;
    private final ClusteredStatsService clusteredStatsService;
    private final ClusterHealthCheckService clusterHealthCheckService;
    private final ClusterManager clusterManager;

    @GetMapping(path={"/health"})
    public List<ClusterHealthDTO> health() {
        List clusters = this.clusterManager.getAllClusterNames();
        return clusters.stream().map(arg_0 -> ((ClusterHealthCheckService)this.clusterHealthCheckService).check(arg_0)).sorted(Comparator.comparingInt(o -> o.getConnection().ordinal())).collect(Collectors.toList());
    }

    @GetMapping(path={"/license"})
    public Map<String, Long> license() {
        return Collections.singletonMap("licenseExpirationTime", this.licenseManager.isLicenseConfigured() ? this.licenseManager.getLicenseDate() : -1L);
    }

    @GetMapping(path={"/clusters"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> clusters() {
        return this.enterpriseServiceProvider.getClusterNames(FEATURE);
    }

    @GetMapping(path={"/clusters/{cluster}"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public ClusterHealthDTO clusterHealth(@PathVariable String cluster) {
        return this.clusterHealthCheckService.check(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/members"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> members(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getMembers();
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}"})
    public MemberStatsDTO member(@PathVariable String cluster, @PathVariable String member) {
        TimedMemberState timedMemberState = this.getTimedMemberState(cluster, member);
        return this.clusteredStatsService.getMemberStats(cluster, member, timedMemberState);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/connectionManager"})
    public ConnectionManagerStatsDTO connectionManager(@PathVariable String cluster, @PathVariable String member) {
        this.ensureMember(cluster, member);
        return this.clusteredStatsService.getConnectionManagerStats(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/operationService"})
    public OperationServiceStatsDTO operationService(@PathVariable String cluster, @PathVariable String member) {
        this.ensureMember(cluster, member);
        return this.clusteredStatsService.getOperationServiceStats(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/eventService"})
    public EventServiceStatsDTO eventService(@PathVariable String cluster, @PathVariable String member) {
        this.ensureMember(cluster, member);
        return this.clusteredStatsService.getEventServiceStats(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/partitionService"})
    public PartitionServiceStatsDTO partitionService(@PathVariable String cluster, @PathVariable String member) {
        this.ensureMember(cluster, member);
        return this.clusteredStatsService.getPartitionServiceStats(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/proxyService"})
    public ProxyServiceStatsDTO proxyService(@PathVariable String cluster, @PathVariable String member) {
        this.ensureMember(cluster, member);
        return this.clusteredStatsService.getProxyServiceStats(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/managedExecutors"})
    public Set<String> getManagedExecutorNames(@PathVariable String cluster, @PathVariable String member) {
        this.ensureMember(cluster, member);
        return HzExecutorNames.EXECUTOR_NAMES;
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/managedExecutors/{managedExecutor}"})
    public ManagedExecutorStatsDTO getManagedExecutor(@PathVariable String cluster, @PathVariable String member, @PathVariable String managedExecutor) {
        this.ensureMember(cluster, member);
        return this.clusteredStatsService.getManagedExecutorStats(cluster, member, managedExecutor);
    }

    @GetMapping(path={"/clusters/{cluster}/state"})
    public ClusterStateDTO state(@PathVariable String cluster) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        return this.clusteredStatsService.getClusterState(cluster, latestState);
    }

    @GetMapping(path={"/clusters/{cluster}/maps"})
    public Set<String> maps(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.MAP);
    }

    @GetMapping(path={"/clusters/{cluster}/maps/{map}"})
    public MapStatsDTO map(@PathVariable String cluster, @PathVariable String map) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.MAP, map);
        return this.clusteredStatsService.getMapStats(cluster, map);
    }

    @GetMapping(path={"/clusters/{cluster}/replicatedmaps"})
    public Set<String> replicatedmaps(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.REPLICATED_MAP);
    }

    @GetMapping(path={"/clusters/{cluster}/replicatedmaps/{replicatedMap}"})
    public ReplicatedMapStatsDTO replicatedmap(@PathVariable String cluster, @PathVariable String replicatedMap) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.REPLICATED_MAP, replicatedMap);
        return this.clusteredStatsService.getReplicatedMapStats(cluster, replicatedMap);
    }

    @GetMapping(path={"/clusters/{cluster}/caches"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> caches(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.CACHE);
    }

    @GetMapping(path={"/clusters/{cluster}/caches/{cache}"})
    public CacheStatsDTO cache(@PathVariable String cluster, @PathVariable String cache) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.CACHE, "/hz/" + cache);
        return this.clusteredStatsService.getCacheStats(cluster, cache);
    }

    @GetMapping(path={"/clusters/{cluster}/multimaps"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> multimaps(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.MULTIMAP);
    }

    @GetMapping(path={"/clusters/{cluster}/multimaps/{multiMap}"})
    public MultiMapStatsDTO multimap(@PathVariable String cluster, @PathVariable String multiMap) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.MULTIMAP, multiMap);
        return this.clusteredStatsService.getMultiMapStats(cluster, multiMap);
    }

    @GetMapping(path={"/clusters/{cluster}/queues"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> queues(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.QUEUE);
    }

    @GetMapping(path={"/clusters/{cluster}/queues/{queue}"})
    public QueueStatsDTO queue(@PathVariable String cluster, @PathVariable String queue) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.QUEUE, queue);
        return this.clusteredStatsService.getQueueStats(cluster, queue);
    }

    @GetMapping(path={"/clusters/{cluster}/topics"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> topics(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.TOPIC);
    }

    @GetMapping(path={"/clusters/{cluster}/topics/{topic}"})
    public TopicStatsDTO topic(@PathVariable String cluster, @PathVariable String topic) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.TOPIC, topic);
        return this.clusteredStatsService.getTopicStats(cluster, topic, InstanceType.TOPIC);
    }

    @GetMapping(path={"/clusters/{cluster}/reliabletopics"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> reliableTopics(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.RELIABLE_TOPIC);
    }

    @GetMapping(path={"/clusters/{cluster}/reliabletopics/{reliableTopic}"})
    public TopicStatsDTO reliableTopic(@PathVariable String cluster, @PathVariable String reliableTopic) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.RELIABLE_TOPIC, reliableTopic);
        return this.clusteredStatsService.getTopicStats(cluster, reliableTopic, InstanceType.RELIABLE_TOPIC);
    }

    @GetMapping(path={"/clusters/{cluster}/executors"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> executors(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.EXECUTOR_SERVICE);
    }

    @GetMapping(path={"/clusters/{cluster}/executors/{executor}"})
    public ExecutorStatsDTO executor(@PathVariable String cluster, @PathVariable String executor) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.EXECUTOR_SERVICE, executor);
        return this.clusteredStatsService.getExecutorStats(cluster, executor);
    }

    @GetMapping(path={"/clusters/{cluster}/pncounters"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> pnCounters(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.COUNTER);
    }

    @GetMapping(path={"/clusters/{cluster}/pncounters/{pnCounter}"})
    public PNCounterStatsDTO pnCounter(@PathVariable String cluster, @PathVariable String pnCounter) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.COUNTER, pnCounter);
        return this.clusteredStatsService.getPNCounterStats(cluster, pnCounter);
    }

    @GetMapping(path={"/clusters/{cluster}/flakeidgenerators"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> flakeIdGenerators(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getInstanceNames(InstanceType.FLAKE_ID_GENERATOR);
    }

    @GetMapping(path={"/clusters/{cluster}/flakeidgenerators/{flakeIdGenerator}"})
    public FlakeIdGeneratorStatsDTO flakeIdGenerator(@PathVariable String cluster, @PathVariable String flakeIdGenerator) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsDataStructure(latestState, InstanceType.FLAKE_ID_GENERATOR, flakeIdGenerator);
        return this.clusteredStatsService.getFlakeIdGeneratorStats(cluster, flakeIdGenerator);
    }

    @GetMapping(path={"/clusters/{cluster}/clientStats"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public Set<String> clientStats(@PathVariable String cluster) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        return latestState.getClientAttributes().keySet();
    }

    @GetMapping(path={"/clusters/{cluster}/clientStats/{uuid}"})
    public ClientStatsDTO clientStat(@PathVariable String cluster, @PathVariable String uuid) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        ClientAttributes clientMetadata = (ClientAttributes)latestState.getClientAttributes().get(uuid);
        if (clientMetadata == null) {
            throw NoClientApiException.forUuid((String)uuid);
        }
        return this.clusteredStatsService.getClientStats(cluster, uuid, clientMetadata);
    }

    @GetMapping(path={"/clusters/{cluster}/wanStats/{wanReplication}/publishers/{publisher}"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public WanRepStatsDTO wanStat(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        this.ensureAtLeastOneMemberContainsWANConfigAndPublisher(latestState, cluster, wanReplication, publisher);
        return this.clusteredStatsService.getWanRepStats(cluster, wanReplication, publisher);
    }

    private TimedMemberState getTimedMemberState(String cluster, String member) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        if (latestState == null) {
            throw new NoClusterApiException(cluster);
        }
        TimedMemberState timedMemberState = (TimedMemberState)latestState.getTimedMemberStates().get(member);
        if (timedMemberState == null) {
            throw new NoMemberApiException(member);
        }
        return timedMemberState;
    }

    private void ensureMember(String cluster, String member) {
        this.getTimedMemberState(cluster, member);
    }

    private void ensureAtLeastOneMemberContainsDataStructure(AllState state, InstanceType instanceType, String name) {
        boolean atLeastOneMemberContainsDataStructure = StreamSupport.stream(state.getMemberStates().spliterator(), false).anyMatch(memberState -> memberState.getInstanceNames(instanceType).contains(name));
        if (!atLeastOneMemberContainsDataStructure) {
            throw new NoDataStructureApiException(instanceType, name);
        }
    }

    private void ensureAtLeastOneMemberContainsWANConfigAndPublisher(AllState state, String cluster, String wanConfig, String publisher) {
        boolean atLeastOneMemberContainsWAN = StreamSupport.stream(state.getMemberStates().spliterator(), false).map(memberState -> memberState.getLocalWanStats(wanConfig)).filter(Objects::nonNull).anyMatch(localWanStats -> localWanStats.getLocalWanPublisherStats().containsKey(publisher));
        if (!atLeastOneMemberContainsWAN) {
            throw new NoResourceApiException("WAN config " + wanConfig + " and publisher " + publisher + " for cluster " + cluster);
        }
    }

    @ConstructorProperties(value={"enterpriseServiceProvider", "licenseManager", "clusteredStatsService", "clusterHealthCheckService", "clusterManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusteredRestController(EnterpriseServiceProvider enterpriseServiceProvider, LicenseManager licenseManager, ClusteredStatsService clusteredStatsService, ClusterHealthCheckService clusterHealthCheckService, ClusterManager clusterManager) {
        this.enterpriseServiceProvider = enterpriseServiceProvider;
        this.licenseManager = licenseManager;
        this.clusteredStatsService = clusteredStatsService;
        this.clusterHealthCheckService = clusterHealthCheckService;
        this.clusterManager = clusterManager;
    }
}

