/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.external;

import com.hazelcast.webmonitor.controller.dto.ApiErrorDTO;
import com.hazelcast.webmonitor.controller.dto.clusterconnectionconfig.ClusterConnectionConfigDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.exception.InvalidClusterConnectionConfigException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/rest/mc/clusterConnectionConfigs"})
@ConditionalOnProperty(name={"hazelcast.mc.rest.enabled"}, havingValue="true")
public class ClusterConnectionConfigController {
    private final ClusterManager clusterManager;

    static ClusterConnectionConfigDTO toDTO(ClusterModel model) {
        ClusterConnectionConfigDTO dto = new ClusterConnectionConfigDTO();
        dto.setClusterName(model.getName());
        dto.setMemberAddresses((List)Optional.ofNullable(model.getMemberAddresses()).map(Arrays::asList).map(ArrayList::new).orElse(null));
        dto.setClientConfigType((String)Optional.ofNullable(model.getClientConfigType()).map(Enum::name).orElse(null));
        dto.setClientConfig(model.getClientConfig());
        dto.setEnabled(model.isEnabled());
        return dto;
    }

    static ClusterModel toModel(ClusterConnectionConfigDTO dto) {
        ClusterModel.ClientConfigType clientConfigType;
        boolean hasClientConfig;
        boolean hasMemberAddresses = dto.hasMemberAddresses();
        if (hasMemberAddresses == (hasClientConfig = dto.hasClientConfig())) {
            throw new ValidationFailedApiException("Cluster connection should be configured either with memberAddresses or with clientConfig");
        }
        if (hasMemberAddresses) {
            return new ClusterModel(dto.getClusterName(), dto.getMemberAddresses().toArray(new String[0]), dto.isEnabled());
        }
        String clientConfig = dto.getClientConfig();
        if (clientConfig == null || clientConfig.isEmpty()) {
            throw new ValidationFailedApiException("clientConfig should not be empty");
        }
        try {
            clientConfigType = ClusterModel.ClientConfigType.valueOf((String)dto.getClientConfigType());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new ValidationFailedApiException("clientConfigType should be either XML or YAML");
        }
        return new ClusterModel(dto.getClusterName(), clientConfigType, clientConfig, dto.isEnabled());
    }

    @GetMapping
    public List<ClusterConnectionConfigDTO> getClusterConfigs() {
        return this.clusterManager.getAllClusterConfigs().stream().map(ClusterConnectionConfigController::toDTO).collect(Collectors.toList());
    }

    @GetMapping(value={"/{clusterName}"})
    public ClusterConnectionConfigDTO getClusterConfig(@PathVariable String clusterName) {
        return ClusterConnectionConfigController.toDTO((ClusterModel)this.clusterManager.getCluster(clusterName));
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateConfig(@Valid @RequestBody ClusterConnectionConfigDTO config, BindingResult bindingResult) throws URISyntaxException, UnsupportedEncodingException {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        try {
            boolean updated = this.clusterManager.createOrUpdateCluster(ClusterConnectionConfigController.toModel((ClusterConnectionConfigDTO)config));
            if (updated) {
                return ResponseEntity.ok().build();
            }
        }
        catch (InvalidClusterConnectionConfigException e) {
            return ResponseEntity.badRequest().body((Object)new ApiErrorDTO("CLUSTER_NAME_MISMATCH", e.getMessage()));
        }
        String encodedClusterName = URLEncoder.encode(config.getClusterName(), "UTF-8");
        return ResponseEntity.created((URI)new URI("/rest/mc/clusterConnectionConfigs/" + encodedClusterName)).build();
    }

    @DeleteMapping(value={"/{clusterName}"})
    public void deleteClusterConfig(@PathVariable String clusterName) {
        this.clusterManager.getCluster(clusterName);
        this.clusterManager.remove(clusterName);
    }

    @ConstructorProperties(value={"clusterManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterConnectionConfigController(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }
}

