/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto.clustered.jet;

import com.hazelcast.webmonitor.controller.dto.clustered.jet.EdgeTransceptionDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.jet.ProcessorDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.jet.VertexDTO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import lombok.Generated;

public final class VertexDTO
implements CompositeDataView {
    private static final CompositeType EDGE_TRANSCEPTION_ROW_TYPE;
    private static final TabularType EDGE_TRANSCEPTION_TABULAR_TYPE;
    private static final CompositeType PROCESSOR_ROW_TYPE;
    private static final TabularType PROCESSOR_TABULAR_TYPE;
    private static final CompositeType COMPOSITE_TYPE;
    private static final String[] EDGE_TRANSCEPTION_ROW_ITEMS;
    private static final String[] PROCESSOR_ROW_ITEMS;
    private static final String[] ITEMS;
    private final String id;
    private final long totalIn;
    private final long lastMinIn;
    private final long totalOut;
    private final long lastMinOut;
    private final long maxLatencyToRealTime;
    private final long skew;
    private final int parallelism;
    private final int globalParallelism;
    private final Map<String, EdgeTransceptionDTO> incoming;
    private final Map<String, EdgeTransceptionDTO> outgoing;
    private final Map<Integer, ProcessorDTO> processors;

    @Override
    public CompositeData toCompositeData(CompositeType ct) {
        return new CompositeDataSupport(COMPOSITE_TYPE, ITEMS, new Object[]{this.id, this.totalIn, this.lastMinIn, this.totalOut, this.lastMinOut, this.maxLatencyToRealTime, this.skew, this.parallelism, this.globalParallelism, this.toTabularData(this.incoming), this.toTabularData(this.outgoing), this.processorData()});
    }

    private TabularDataSupport processorData() throws OpenDataException {
        TabularDataSupport processorData = new TabularDataSupport(PROCESSOR_TABULAR_TYPE);
        for (Map.Entry entry : this.processors.entrySet()) {
            processorData.put(new CompositeDataSupport(PROCESSOR_ROW_TYPE, PROCESSOR_ROW_ITEMS, new Object[]{entry.getKey(), ((ProcessorDTO)entry.getValue()).toCompositeData(ProcessorDTO.COMPOSITE_TYPE)}));
        }
        return processorData;
    }

    private TabularDataSupport toTabularData(Map<String, EdgeTransceptionDTO> edgeTransceptionDTOs) throws OpenDataException {
        TabularDataSupport tabularData = new TabularDataSupport(EDGE_TRANSCEPTION_TABULAR_TYPE);
        for (Map.Entry<String, EdgeTransceptionDTO> entry : edgeTransceptionDTOs.entrySet()) {
            tabularData.put(new CompositeDataSupport(EDGE_TRANSCEPTION_ROW_TYPE, EDGE_TRANSCEPTION_ROW_ITEMS, new Object[]{entry.getKey(), entry.getValue().toCompositeData(EdgeTransceptionDTO.COMPOSITE_TYPE)}));
        }
        return tabularData;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static VertexDTOBuilder builder() {
        return new VertexDTOBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTotalIn() {
        return this.totalIn;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLastMinIn() {
        return this.lastMinIn;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTotalOut() {
        return this.totalOut;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLastMinOut() {
        return this.lastMinOut;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxLatencyToRealTime() {
        return this.maxLatencyToRealTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSkew() {
        return this.skew;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getParallelism() {
        return this.parallelism;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getGlobalParallelism() {
        return this.globalParallelism;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, EdgeTransceptionDTO> getIncoming() {
        return this.incoming;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, EdgeTransceptionDTO> getOutgoing() {
        return this.outgoing;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Integer, ProcessorDTO> getProcessors() {
        return this.processors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexDTO)) {
            return false;
        }
        VertexDTO other = (VertexDTO)o;
        if (this.getTotalIn() != other.getTotalIn()) {
            return false;
        }
        if (this.getLastMinIn() != other.getLastMinIn()) {
            return false;
        }
        if (this.getTotalOut() != other.getTotalOut()) {
            return false;
        }
        if (this.getLastMinOut() != other.getLastMinOut()) {
            return false;
        }
        if (this.getMaxLatencyToRealTime() != other.getMaxLatencyToRealTime()) {
            return false;
        }
        if (this.getSkew() != other.getSkew()) {
            return false;
        }
        if (this.getParallelism() != other.getParallelism()) {
            return false;
        }
        if (this.getGlobalParallelism() != other.getGlobalParallelism()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map this$incoming = this.getIncoming();
        Map other$incoming = other.getIncoming();
        if (this$incoming == null ? other$incoming != null : !((Object)this$incoming).equals(other$incoming)) {
            return false;
        }
        Map this$outgoing = this.getOutgoing();
        Map other$outgoing = other.getOutgoing();
        if (this$outgoing == null ? other$outgoing != null : !((Object)this$outgoing).equals(other$outgoing)) {
            return false;
        }
        Map this$processors = this.getProcessors();
        Map other$processors = other.getProcessors();
        return !(this$processors == null ? other$processors != null : !((Object)this$processors).equals(other$processors));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalIn = this.getTotalIn();
        result = result * 59 + (int)($totalIn >>> 32 ^ $totalIn);
        long $lastMinIn = this.getLastMinIn();
        result = result * 59 + (int)($lastMinIn >>> 32 ^ $lastMinIn);
        long $totalOut = this.getTotalOut();
        result = result * 59 + (int)($totalOut >>> 32 ^ $totalOut);
        long $lastMinOut = this.getLastMinOut();
        result = result * 59 + (int)($lastMinOut >>> 32 ^ $lastMinOut);
        long $maxLatencyToRealTime = this.getMaxLatencyToRealTime();
        result = result * 59 + (int)($maxLatencyToRealTime >>> 32 ^ $maxLatencyToRealTime);
        long $skew = this.getSkew();
        result = result * 59 + (int)($skew >>> 32 ^ $skew);
        result = result * 59 + this.getParallelism();
        result = result * 59 + this.getGlobalParallelism();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map $incoming = this.getIncoming();
        result = result * 59 + ($incoming == null ? 43 : ((Object)$incoming).hashCode());
        Map $outgoing = this.getOutgoing();
        result = result * 59 + ($outgoing == null ? 43 : ((Object)$outgoing).hashCode());
        Map $processors = this.getProcessors();
        result = result * 59 + ($processors == null ? 43 : ((Object)$processors).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "VertexDTO(id=" + this.getId() + ", totalIn=" + this.getTotalIn() + ", lastMinIn=" + this.getLastMinIn() + ", totalOut=" + this.getTotalOut() + ", lastMinOut=" + this.getLastMinOut() + ", maxLatencyToRealTime=" + this.getMaxLatencyToRealTime() + ", skew=" + this.getSkew() + ", parallelism=" + this.getParallelism() + ", globalParallelism=" + this.getGlobalParallelism() + ", incoming=" + this.getIncoming() + ", outgoing=" + this.getOutgoing() + ", processors=" + this.getProcessors() + ")";
    }

    @ConstructorProperties(value={"id", "totalIn", "lastMinIn", "totalOut", "lastMinOut", "maxLatencyToRealTime", "skew", "parallelism", "globalParallelism", "incoming", "outgoing", "processors"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public VertexDTO(String id, long totalIn, long lastMinIn, long totalOut, long lastMinOut, long maxLatencyToRealTime, long skew, int parallelism, int globalParallelism, Map<String, EdgeTransceptionDTO> incoming, Map<String, EdgeTransceptionDTO> outgoing, Map<Integer, ProcessorDTO> processors) {
        this.id = id;
        this.totalIn = totalIn;
        this.lastMinIn = lastMinIn;
        this.totalOut = totalOut;
        this.lastMinOut = lastMinOut;
        this.maxLatencyToRealTime = maxLatencyToRealTime;
        this.skew = skew;
        this.parallelism = parallelism;
        this.globalParallelism = globalParallelism;
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.processors = processors;
    }

    static {
        EDGE_TRANSCEPTION_ROW_ITEMS = new String[]{"TargetVertex", "Info"};
        PROCESSOR_ROW_ITEMS = new String[]{"ProcessorId", "Info"};
        ITEMS = new String[]{"Id", "TotalIn", "LastMinIn", "TotalOut", "LastMinOut", "MaxLatencyToRealTime", "Skew", "Parallelism", "GlobalParallelism", "Incoming", "Outgoing", "Processors"};
        PROCESSOR_ROW_TYPE = new CompositeType("ProcessorRow", "ProcessorRow", PROCESSOR_ROW_ITEMS, PROCESSOR_ROW_ITEMS, new OpenType[]{SimpleType.INTEGER, ProcessorDTO.COMPOSITE_TYPE});
        PROCESSOR_TABULAR_TYPE = new TabularType("ProcessorTabular", "ProcessorTabular", PROCESSOR_ROW_TYPE, new String[]{"ProcessorId"});
        EDGE_TRANSCEPTION_ROW_TYPE = new CompositeType("EdgeTransceptionRow", "EdgeTransceptionRow", EDGE_TRANSCEPTION_ROW_ITEMS, EDGE_TRANSCEPTION_ROW_ITEMS, new OpenType[]{SimpleType.STRING, EdgeTransceptionDTO.COMPOSITE_TYPE});
        EDGE_TRANSCEPTION_TABULAR_TYPE = new TabularType("EdgeTransceptionTabular", "EdgeTransceptionTabular", EDGE_TRANSCEPTION_ROW_TYPE, new String[]{"TargetVertex"});
        COMPOSITE_TYPE = new CompositeType("Vertex", "Vertex", ITEMS, ITEMS, new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, EDGE_TRANSCEPTION_TABULAR_TYPE, EDGE_TRANSCEPTION_TABULAR_TYPE, PROCESSOR_TABULAR_TYPE});
    }
}

