/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.webmonitor.service.client.MCWanBatchPublisherConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;

public final class AddWanReplicationDTO {
    @NotEmpty
    private final String name;
    @NotEmpty
    private final String targetClusterName;
    @NotEmpty
    private final String publisherId;
    @NotEmpty
    private final String endpoints;
    private final int queueCapacity = 10000;
    private final int batchSize = 500;
    private final int batchMaxDelay = 1000;
    private final int responseTimeout = 60000;
    private final WanAcknowledgeType ackType = WanBatchPublisherConfig.DEFAULT_ACKNOWLEDGE_TYPE;
    private final WanQueueFullBehavior queueFullBehaviour = WanBatchPublisherConfig.DEFAULT_QUEUE_FULL_BEHAVIOUR;

    public MCWanBatchPublisherConfig toModel() {
        MCWanBatchPublisherConfig config = new MCWanBatchPublisherConfig();
        config.setName(this.name);
        config.setTargetCluster(this.targetClusterName);
        config.setPublisherId(this.publisherId);
        config.setEndpoints(this.endpoints);
        config.setQueueCapacity(10000);
        config.setBatchSize(500);
        config.setBatchMaxDelayMillis(1000);
        config.setResponseTimeoutMillis(60000);
        config.setAckType(this.ackType);
        config.setQueueFullBehaviour(this.queueFullBehaviour);
        return config;
    }

    @ConstructorProperties(value={"name", "targetClusterName", "publisherId", "endpoints"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AddWanReplicationDTO(String name, String targetClusterName, String publisherId, String endpoints) {
        this.name = name;
        this.targetClusterName = targetClusterName;
        this.publisherId = publisherId;
        this.endpoints = endpoints;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetClusterName() {
        return this.targetClusterName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPublisherId() {
        return this.publisherId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEndpoints() {
        return this.endpoints;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getQueueCapacity() {
        Objects.requireNonNull(this);
        return 10000;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBatchSize() {
        Objects.requireNonNull(this);
        return 500;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBatchMaxDelay() {
        Objects.requireNonNull(this);
        return 1000;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getResponseTimeout() {
        Objects.requireNonNull(this);
        return 60000;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WanAcknowledgeType getAckType() {
        return this.ackType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WanQueueFullBehavior getQueueFullBehaviour() {
        return this.queueFullBehaviour;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddWanReplicationDTO)) {
            return false;
        }
        AddWanReplicationDTO other = (AddWanReplicationDTO)o;
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getBatchMaxDelay() != other.getBatchMaxDelay()) {
            return false;
        }
        if (this.getResponseTimeout() != other.getResponseTimeout()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$targetClusterName = this.getTargetClusterName();
        String other$targetClusterName = other.getTargetClusterName();
        if (this$targetClusterName == null ? other$targetClusterName != null : !this$targetClusterName.equals(other$targetClusterName)) {
            return false;
        }
        String this$publisherId = this.getPublisherId();
        String other$publisherId = other.getPublisherId();
        if (this$publisherId == null ? other$publisherId != null : !this$publisherId.equals(other$publisherId)) {
            return false;
        }
        String this$endpoints = this.getEndpoints();
        String other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !this$endpoints.equals(other$endpoints)) {
            return false;
        }
        WanAcknowledgeType this$ackType = this.getAckType();
        WanAcknowledgeType other$ackType = other.getAckType();
        if (this$ackType == null ? other$ackType != null : !this$ackType.equals(other$ackType)) {
            return false;
        }
        WanQueueFullBehavior this$queueFullBehaviour = this.getQueueFullBehaviour();
        WanQueueFullBehavior other$queueFullBehaviour = other.getQueueFullBehaviour();
        return !(this$queueFullBehaviour == null ? other$queueFullBehaviour != null : !this$queueFullBehaviour.equals(other$queueFullBehaviour));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getBatchMaxDelay();
        result = result * 59 + this.getResponseTimeout();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $targetClusterName = this.getTargetClusterName();
        result = result * 59 + ($targetClusterName == null ? 43 : $targetClusterName.hashCode());
        String $publisherId = this.getPublisherId();
        result = result * 59 + ($publisherId == null ? 43 : $publisherId.hashCode());
        String $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : $endpoints.hashCode());
        WanAcknowledgeType $ackType = this.getAckType();
        result = result * 59 + ($ackType == null ? 43 : $ackType.hashCode());
        WanQueueFullBehavior $queueFullBehaviour = this.getQueueFullBehaviour();
        result = result * 59 + ($queueFullBehaviour == null ? 43 : $queueFullBehaviour.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AddWanReplicationDTO(name=" + this.getName() + ", targetClusterName=" + this.getTargetClusterName() + ", publisherId=" + this.getPublisherId() + ", endpoints=" + this.getEndpoints() + ", queueCapacity=" + this.getQueueCapacity() + ", batchSize=" + this.getBatchSize() + ", batchMaxDelay=" + this.getBatchMaxDelay() + ", responseTimeout=" + this.getResponseTimeout() + ", ackType=" + this.getAckType() + ", queueFullBehaviour=" + this.getQueueFullBehaviour() + ")";
    }
}

