/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.WebSocketConfig;
import com.hazelcast.webmonitor.config.WebSocketMessageBrokerConfig;
import com.hazelcast.webmonitor.config.properties.WebSocketConfigurationProperties;
import com.hazelcast.webmonitor.notify.Notifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.config.annotation.web.messaging.MessageSecurityMetadataSourceRegistry;
import org.springframework.security.config.annotation.web.socket.AbstractSecurityWebSocketMessageBrokerConfigurer;
import org.springframework.util.MimeType;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.messaging.StompSubProtocolErrorHandler;
import org.springframework.web.socket.server.HandshakeHandler;

@Configuration
@EnableScheduling
@Import(value={WebSocketMessageBrokerConfig.class})
public class WebSocketConfig
extends AbstractSecurityWebSocketMessageBrokerConfigurer {
    public static final String TOPIC_SQL_RESULTS = "/topic/sql-results/";
    protected final Notifier notifier;
    private TaskScheduler messageBrokerTaskScheduler;
    private WebSocketConfigurationProperties webSocketConfigurationProperties;

    @Autowired
    public void setMessageBrokerTaskScheduler(@Lazy TaskScheduler taskScheduler, WebSocketConfigurationProperties webSocketConfigurationProperties) {
        this.messageBrokerTaskScheduler = taskScheduler;
        this.webSocketConfigurationProperties = webSocketConfigurationProperties;
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.setErrorHandler((StompSubProtocolErrorHandler)new StompErrorHandler(null));
        registry.addEndpoint(new String[]{"/ws"}).setHandshakeHandler((HandshakeHandler)new NotifyingHandshakeHandler(this.notifier));
        registry.setOrder(Integer.MIN_VALUE);
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.messageBrokerTaskScheduler);
        registry.setPreservePublishOrder(true);
    }

    protected void configureInbound(MessageSecurityMetadataSourceRegistry messages) {
        messages.simpMessageDestMatchers(new String[]{"/user/**"}).denyAll().simpMessageDestMatchers(new String[]{"/topic/**"}).denyAll().simpSubscribeDestMatchers(new String[]{"/topic/sql-results/**"}).hasAnyRole(new String[]{"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"}).simpTypeMatchers(new SimpMessageType[]{SimpMessageType.DISCONNECT}).permitAll().anyMessage().authenticated();
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new MappingJackson2MessageConverter(new MimeType[]{MediaType.APPLICATION_JSON}));
        return false;
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setSendBufferSizeLimit((int)this.webSocketConfigurationProperties.getBufferSize().toBytes());
    }

    @ConstructorProperties(value={"notifier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WebSocketConfig(Notifier notifier) {
        this.notifier = notifier;
    }
}

