/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.zaxxer.hikari.HikariDataSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.sql.DataSource;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.output.MigrateResult;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SqlDbConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlDbConfig.class);
    private static final String DEFAULT_DB_USERNAME = "mc";
    private static final String DB_FILE = "mc";
    private static final String DB_DIR = "sql";
    private final boolean skipLocking;

    public SqlDbConfig(boolean skipLocking) {
        this.skipLocking = skipLocking;
    }

    @Autowired
    public SqlDbConfig(MCConfigurationProperties properties) {
        this(properties.isSkipLocking());
    }

    @Bean
    public Jdbi jdbi(DataSource ds) {
        this.migrateDB(ds);
        Jdbi jdbi = Jdbi.create((DataSource)ds);
        jdbi.registerArrayType(String.class, "VARCHAR(255)");
        return jdbi;
    }

    @Bean
    public HikariDataSource dataSource(HomeDirectoryProvider homeDirectoryProvider) {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(this.getJdbcUrl(homeDirectoryProvider));
        ds.setDriverClassName("org.h2.Driver");
        ds.setUsername("mc");
        ds.setPassword(null);
        ds.setMinimumIdle(1);
        ds.setMaximumPoolSize(10);
        return ds;
    }

    private void migrateDB(DataSource ds) {
        log.info("Checking DB for required migrations.");
        Flyway flyway = Flyway.configure().dataSource(ds).load();
        try {
            this.applyMigrations(flyway);
        }
        catch (FlywayException e) {
            try {
                flyway.repair();
                this.applyMigrations(flyway);
            }
            catch (Exception ex) {
                this.handleFailedMigration(ex);
            }
        }
        catch (Exception e) {
            this.handleFailedMigration(e);
        }
    }

    private void applyMigrations(Flyway flyway) {
        MigrateResult migrateResult = flyway.migrate();
        log.info("Number of applied DB migrations: {}.", (Object)migrateResult.migrationsExecuted);
    }

    private void handleFailedMigration(Exception e) {
        throw new Error("Could not migrate SQL DB.", e);
    }

    private String getJdbcUrl(HomeDirectoryProvider homeDirectoryProvider) {
        String dbPath = homeDirectoryProvider.get().resolve(DB_DIR).resolve("mc").toString().replace("\\", "/");
        String url = "jdbc:h2:file:" + dbPath + ";USER=" + "mc";
        if (this.skipLocking) {
            url = url + ";FILE_LOCK=NO";
        }
        return url;
    }
}

