/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.config.SecurityConfig;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.BearerTokenAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.CustomAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.CustomAuthenticationSuccessHandler;
import com.hazelcast.webmonitor.security.LoginListener;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.session.SessionControlAuthenticationStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;

@EnableWebSecurity
public class SecurityConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String[] ALL_ROLES = new String[]{"ADMIN", "USER", "READONLY_USER", "METRICS_ONLY", "CLOUD_USER"};
    public static final int ONE_YEAR_IN_SECONDS = 31536000;
    public static final String CSP_HEADER_VALUE = "script-src 'self' 'unsafe-inline' 'unsafe-eval'; script-src-elem 'self' 'unsafe-inline' 'unsafe-eval' app.pendo.io pendo-io-static.storage.googleapis.com cdn.pendo.io pendo-static-6720724486979584.storage.googleapis.com data.pendo.io; frame-ancestors 'self' *.hazelcast.cloud localhost:*";
    private final CustomAuthenticationFailureHandler failureHandler;
    private final BearerTokenAuthenticationFailureHandler bearerTokenFailureHandler;
    private final List<LoginListener> loginListeners;
    private final AuthTokenManager authTokenManager;
    private final AuthenticationManagerImpl authenticationManager;
    private final AuditLogService auditService;
    private final MCConfigurationProperties mcProperties;

    public String makeCSPHeaderValue() {
        return "script-src 'self' 'unsafe-inline' 'unsafe-eval'; script-src-elem 'self' 'unsafe-inline' 'unsafe-eval' app.pendo.io pendo-io-static.storage.googleapis.com cdn.pendo.io pendo-static-6720724486979584.storage.googleapis.com data.pendo.io; frame-ancestors 'self' *.hazelcast.cloud localhost:* " + Optional.ofNullable(this.mcProperties.getInternal().getCloudAddress()).orElse("");
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new AuditLoggingSessionRegistryImpl(this, null);
    }

    @Bean
    public CompositeSessionAuthenticationStrategy sessionAuthenticationStrategy(SessionRegistry sessionRegistry) {
        return new CompositeSessionAuthenticationStrategy(Arrays.asList(new SessionControlAuthenticationStrategy(sessionRegistry, this.mcProperties), new SessionFixationProtectionStrategy(), new RegisterSessionAuthenticationStrategy(sessionRegistry)));
    }

    @Bean
    public UsernamePasswordAuthenticationFilter authenticationFilter(SessionRegistry sessionRegistry, AuthenticationSuccessHandler successHandler) {
        LoginAuthenticationFilter filter = new LoginAuthenticationFilter(this, null);
        filter.setAuthenticationManager((AuthenticationManager)this.authenticationManager);
        filter.setAuthenticationSuccessHandler(successHandler);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)this.sessionAuthenticationStrategy(sessionRegistry));
        return filter;
    }

    @Bean
    public CustomAuthenticationSuccessHandler authenticationSuccessHandler(UserDAO userDAO, Clock clock) {
        boolean isCloudEnabled = this.mcProperties.getInternal().isCloud();
        return new CustomAuthenticationSuccessHandler(userDAO, this.auditService, clock, isCloudEnabled);
    }

    @Bean
    public BearerTokenAuthenticationFilter bearerAuthenticationFilter() {
        BearerTokenAuthenticationFilter filter = new BearerTokenAuthenticationFilter(this, "/rest/**");
        filter.setAuthenticationManager((AuthenticationManager)this.authenticationManager);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.bearerTokenFailureHandler);
        filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
        return filter;
    }

    @Bean
    public DefaultWebSecurityExpressionHandler securityExpressionHandler() {
        return new DefaultWebSecurityExpressionHandler();
    }

    @Bean
    public ConcurrentSessionFilter concurrencyFilter(SessionRegistry sessionRegistry) {
        return new ConcurrentSessionFilter(sessionRegistry, (SessionInformationExpiredStrategy)new SimpleRedirectSessionInformationExpiredStrategy("/expireSession"));
    }

    @ConstructorProperties(value={"failureHandler", "bearerTokenFailureHandler", "loginListeners", "authTokenManager", "authenticationManager", "auditService", "mcProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SecurityConfig(CustomAuthenticationFailureHandler failureHandler, BearerTokenAuthenticationFailureHandler bearerTokenFailureHandler, List<LoginListener> loginListeners, AuthTokenManager authTokenManager, AuthenticationManagerImpl authenticationManager, AuditLogService auditService, MCConfigurationProperties mcProperties) {
        this.failureHandler = failureHandler;
        this.bearerTokenFailureHandler = bearerTokenFailureHandler;
        this.loginListeners = loginListeners;
        this.authTokenManager = authTokenManager;
        this.authenticationManager = authenticationManager;
        this.auditService = auditService;
        this.mcProperties = mcProperties;
    }

    static /* synthetic */ AuthenticationManagerImpl access$000(SecurityConfig x0) {
        return x0.authenticationManager;
    }

    static /* synthetic */ String[] access$100() {
        return ALL_ROLES;
    }

    static /* synthetic */ MCConfigurationProperties access$200(SecurityConfig x0) {
        return x0.mcProperties;
    }

    static /* synthetic */ List access$600(SecurityConfig x0) {
        return x0.loginListeners;
    }

    static /* synthetic */ AuthTokenManager access$700(SecurityConfig x0) {
        return x0.authTokenManager;
    }

    static /* synthetic */ Logger access$800() {
        return log;
    }

    static /* synthetic */ AuditLogService access$900(SecurityConfig x0) {
        return x0.auditService;
    }
}

